/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.coloc.icq;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.coloc.ColocUtil;
import net.imagej.ops.special.function.AbstractBinaryFunctionOp;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.IterablePair;
import net.imglib2.util.Pair;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Coloc.ICQ.class)
public class LiICQ<T extends RealType<T>, U extends RealType<U>>
extends AbstractBinaryFunctionOp<Iterable<T>, Iterable<U>, Double>
implements Ops.Coloc.ICQ,
Contingent {
    @Parameter(required=false)
    private DoubleType mean1;
    @Parameter(required=false)
    private DoubleType mean2;

    @Override
    public Double calculate(Iterable<T> image1, Iterable<U> image2) {
        IterablePair samples = new IterablePair(image1, image2);
        double m1 = this.mean1 == null ? this.computeMeanOf(image1) : this.mean1.get();
        double m2 = this.mean2 == null ? this.computeMeanOf(image2) : this.mean2.get();
        long numPositiveProducts = 0L;
        long numNegativeProducts = 0L;
        for (Pair value : samples) {
            double ch2;
            double ch1 = ((RealType)value.getA()).getRealDouble();
            double productOfDifferenceOfMeans = (m1 - ch1) * (m2 - (ch2 = ((RealType)value.getB()).getRealDouble()));
            if (productOfDifferenceOfMeans < 0.0) {
                ++numNegativeProducts;
                continue;
            }
            ++numPositiveProducts;
        }
        double icqValue = (double)numPositiveProducts / (double)(numNegativeProducts + numPositiveProducts) - 0.5;
        return icqValue;
    }

    private <V extends RealType<V>> double computeMeanOf(Iterable<V> in) {
        return this.ops().stats().mean(in).getRealDouble();
    }

    @Override
    public boolean conforms() {
        return ColocUtil.sameIterationOrder((Iterable)this.in1(), (Iterable)this.in2());
    }
}

