/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.deconvolve.accelerate;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.inplace.AbstractUnaryInplaceOp;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Deconvolve.Accelerate.class, priority=0.0)
public class VectorAccelerator<T extends RealType<T> & NativeType<T>>
extends AbstractUnaryInplaceOp<RandomAccessibleInterval<T>>
implements Ops.Deconvolve.Accelerate {
    Img<T> xkm1_previous = null;
    Img<T> yk_prediction = null;
    Img<T> hk_vector = null;
    Img<T> gk;
    Img<T> gkm1;
    private UnaryFunctionOp<Dimensions, Img<T>> create;
    double accelerationFactor = 0.0;
    ArrayImgFactory<T> factory;

    @Override
    public void initialize() {
        super.initialize();
        this.factory = new ArrayImgFactory();
        this.create = Functions.unary(this.ops(), Ops.Create.Img.class, Img.class, Dimensions.class, new Object[]{Util.getTypeFromInterval((Interval)((Interval)this.out())), this.factory});
    }

    @Override
    public void mutate(RandomAccessibleInterval<T> yk_iterated) {
        this.accelerate(yk_iterated);
    }

    public void initialize(RandomAccessibleInterval<T> yk_iterated) {
        if (this.yk_prediction == null) {
            long[] temp = new long[yk_iterated.numDimensions()];
            yk_iterated.dimensions(temp);
            FinalDimensions dims = new FinalDimensions(temp);
            this.yk_prediction = this.create.calculate((Dimensions)dims);
            this.xkm1_previous = this.create.calculate((Dimensions)dims);
            this.yk_prediction = this.create.calculate((Dimensions)dims);
            this.gk = this.create.calculate((Dimensions)dims);
            this.hk_vector = this.create.calculate((Dimensions)dims);
        }
    }

    public void accelerate(RandomAccessibleInterval<T> yk_iterated) {
        if (this.yk_prediction != null) {
            this.accelerationFactor = this.computeAccelerationFactor(yk_iterated);
            if (this.accelerationFactor < 0.0) {
                this.gkm1 = null;
                this.accelerationFactor = 0.0;
            }
            if (this.accelerationFactor > 1.0) {
                this.accelerationFactor = 1.0;
            }
        }
        RandomAccessibleInterval<T> xk_estimate = yk_iterated;
        if (this.accelerationFactor > 0.0) {
            this.Subtract(xk_estimate, (RandomAccessibleInterval<T>)this.xkm1_previous, (RandomAccessibleInterval<T>)this.hk_vector);
            this.yk_prediction = this.AddAndScale(xk_estimate, this.hk_vector, (float)this.accelerationFactor);
        } else {
            this.initialize(yk_iterated);
            this.Copy(xk_estimate, (RandomAccessibleInterval<T>)this.yk_prediction);
        }
        this.Copy(xk_estimate, (RandomAccessibleInterval<T>)this.xkm1_previous);
        this.Copy((RandomAccessibleInterval<T>)this.yk_prediction, yk_iterated);
    }

    double computeAccelerationFactor(RandomAccessibleInterval<T> yk_iterated) {
        this.Subtract(yk_iterated, (RandomAccessibleInterval<T>)this.yk_prediction, (RandomAccessibleInterval<T>)this.gk);
        if (this.gkm1 != null) {
            double numerator = this.DotProduct(this.gk, this.gkm1);
            double denominator = this.DotProduct(this.gkm1, this.gkm1);
            this.gkm1 = this.gk.copy();
            return numerator / denominator;
        }
        this.gkm1 = this.gk.copy();
        return 0.0;
    }

    public double DotProduct(Img<T> image1, Img<T> image2) {
        Cursor cursorImage1 = image1.cursor();
        Cursor cursorImage2 = image2.cursor();
        double dotProduct = 0.0;
        while (cursorImage1.hasNext()) {
            cursorImage1.fwd();
            cursorImage2.fwd();
            float val1 = ((RealType)cursorImage1.get()).getRealFloat();
            float val2 = ((RealType)cursorImage2.get()).getRealFloat();
            dotProduct += (double)(val1 * val2);
        }
        return dotProduct;
    }

    protected void Copy(RandomAccessibleInterval<T> a, RandomAccessibleInterval<T> b) {
        Cursor cursorA = Views.iterable(a).cursor();
        Cursor cursorB = Views.iterable(b).cursor();
        while (cursorA.hasNext()) {
            cursorA.fwd();
            cursorB.fwd();
            ((RealType)cursorB.get()).set((Type)cursorA.get());
        }
    }

    protected void Subtract(RandomAccessibleInterval<T> a, RandomAccessibleInterval<T> input, RandomAccessibleInterval<T> output) {
        Cursor cursorA = Views.iterable(a).cursor();
        Cursor cursorInput = Views.iterable(input).cursor();
        Cursor cursorOutput = Views.iterable(output).cursor();
        while (cursorA.hasNext()) {
            cursorA.fwd();
            cursorInput.fwd();
            cursorOutput.fwd();
            ((RealType)cursorOutput.get()).set((Type)cursorA.get());
            ((RealType)cursorOutput.get()).sub(cursorInput.get());
        }
    }

    public Img<T> AddAndScale(RandomAccessibleInterval<T> img1, Img<T> img2, float a) {
        Img<T> out = this.create.calculate((Dimensions)img1);
        Cursor cursor1 = Views.iterable(img1).cursor();
        Cursor cursor2 = img2.cursor();
        Cursor cursorOut = out.cursor();
        while (cursor1.hasNext()) {
            cursor1.fwd();
            cursor2.fwd();
            cursorOut.fwd();
            float val1 = ((RealType)cursor1.get()).getRealFloat();
            float val2 = ((RealType)cursor2.get()).getRealFloat();
            float val3 = Math.max(val1 + a * val2, 1.0E-4f);
            ((RealType)cursorOut.get()).setReal(val3);
        }
        return out;
    }
}

