/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.ifft;

import java.util.concurrent.ExecutorService;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RAIs;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.fft2.FFTMethods;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;

@Plugin(type=Ops.Filter.IFFT.class)
public class IFFTMethodsOpC<C extends ComplexType<C>, T extends RealType<T>>
extends AbstractUnaryComputerOp<RandomAccessibleInterval<C>, RandomAccessibleInterval<T>>
implements Ops.Filter.IFFT,
Contingent {
    @Parameter
    ThreadService ts;
    private UnaryFunctionOp<RandomAccessibleInterval<C>, RandomAccessibleInterval<C>> copyOp;

    @Override
    public void initialize() {
        super.initialize();
        this.copyOp = RAIs.function(this.ops(), Ops.Copy.RAI.class, (RandomAccessibleInterval)this.in(), new Object[0]);
    }

    @Override
    public void compute(RandomAccessibleInterval<C> input, RandomAccessibleInterval<T> output) {
        RandomAccessibleInterval<C> temp = this.copyOp.calculate(input);
        for (int d = input.numDimensions() - 1; d > 0; --d) {
            FFTMethods.complexToComplex(temp, (int)d, (boolean)false, (boolean)true, (ExecutorService)this.ts.getExecutorService());
        }
        FFTMethods.complexToReal(temp, output, (Interval)FFTMethods.unpaddingIntervalCentered(temp, output), (int)0, (boolean)true, (ExecutorService)this.ts.getExecutorService());
    }

    @Override
    public boolean conforms() {
        long[] paddedDimensions = new long[((RandomAccessibleInterval)this.in()).numDimensions()];
        long[] realDimensions = new long[((RandomAccessibleInterval)this.in()).numDimensions()];
        boolean fastSizeConforms = false;
        FFTMethods.dimensionsComplexToRealFast((Dimensions)((Dimensions)this.in()), (long[])paddedDimensions, (long[])realDimensions);
        if (FFTMethods.dimensionsEqual((Interval)((Interval)this.in()), (long[])paddedDimensions)) {
            fastSizeConforms = true;
        }
        boolean smallSizeConforms = false;
        FFTMethods.dimensionsComplexToRealSmall((Dimensions)((Dimensions)this.in()), (long[])paddedDimensions, (long[])realDimensions);
        if (FFTMethods.dimensionsEqual((Interval)((Interval)this.in()), (long[])paddedDimensions)) {
            smallSizeConforms = true;
        }
        return fastSizeConforms || smallSizeConforms;
    }
}

