/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.ImageWriter;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Biorad_Writer
implements PlugIn {
    private static final String plugInName = "Biorad Writer";
    private static final String noImages = "Biorad Writer...\nNo images are open.";
    private static final String supportedTypes = "Biorad Writer...Supported types:\n\n16-bit Greyscale integer: INT\n(16-bit Greyscale unsigned integer) : UNINT\n8-bit Greyscale : BYTE\n8-bit Colour LUT (converted to greyscale): BYTE\n";

    public void run(String arg) {
        SaveDialog sd;
        String file;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.showMessage((String)noImages);
            return;
        }
        if (Biorad_Writer.imgType(imp.getFileInfo().fileType) < 0) {
            IJ.showMessage((String)supportedTypes);
            return;
        }
        String name = arg;
        if (arg == null || arg.equals("")) {
            name = imp.getTitle();
        }
        if ((file = (sd = new SaveDialog("Biorad Writer...", name, ".PIC")).getFileName()) == null) {
            return;
        }
        String directory = sd.getDirectory();
        this.save(imp, directory, file);
    }

    public void save(ImagePlus imp, String directory, String file) {
        int datatype;
        if (imp == null) {
            IJ.showMessage((String)noImages);
            return;
        }
        FileInfo fi = imp.getFileInfo();
        fi.fileType = datatype = Biorad_Writer.imgType(fi.fileType);
        if (datatype < 0) {
            IJ.showMessage((String)supportedTypes);
            return;
        }
        fi.fileName = file;
        fi.directory = directory;
        fi.intelByteOrder = true;
        Calibration cal = imp.getCalibration();
        fi.pixelWidth = cal.pixelWidth;
        fi.pixelHeight = cal.pixelHeight;
        fi.pixelDepth = cal.pixelDepth;
        fi.unit = cal.getUnits();
        if (fi.unit.equals("\u00b5m") || fi.unit.equals("um")) {
            fi.unit = "microns";
        }
        if (IJ.debugMode) {
            IJ.log((String)("FileInfo: " + fi));
        }
        try {
            this.writeImage(fi, cal);
        }
        catch (IOException e) {
            IJ.error((String)("An error occured writing the file.\n \n" + e));
            IJ.showStatus((String)"");
        }
    }

    void writeImage(FileInfo fi, Calibration cal) throws IOException {
        FileOutputStream out = new FileOutputStream(new File(fi.directory, fi.fileName));
        this.writeHeader(fi, out);
        ImageWriter writer = new ImageWriter(fi);
        writer.write((OutputStream)out);
        this.writeFooter(fi, out);
        out.close();
        IJ.showStatus((String)("Saved " + fi.fileName));
    }

    public static int imgType(int fiType) {
        switch (fiType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    void writeDimensions(FileInfo fi, OutputStream out) throws IOException {
        this.writeShort(out, (short)fi.width);
        this.writeShort(out, (short)fi.height);
        this.writeShort(out, (short)fi.nImages);
    }

    void writeHeader(FileInfo fi, OutputStream out) throws IOException {
        String tFileName;
        this.writeDimensions(fi, out);
        this.writeShort(out, (short)0);
        this.writeShort(out, (short)255);
        this.writeInt(out, 1);
        if (fi.fileType == 0) {
            this.writeShort(out, (short)1);
        } else {
            this.writeShort(out, (short)0);
        }
        this.writeShort(out, (short)0);
        int fileNameLength = fi.fileName.length();
        if (fileNameLength <= 31) {
            int terminatorLength = 32 - fileNameLength;
            String terminator = "";
            for (int i = 0; i < terminatorLength; ++i) {
                terminator = terminator + "\u0000";
            }
            tFileName = new String(fi.fileName + terminator);
        } else {
            tFileName = new String(fi.fileName.substring(0, 31) + "\u0000");
        }
        out.write(tFileName.getBytes());
        this.writeShort(out, (short)0);
        this.writeShort(out, (short)7);
        this.writeShort(out, (short)12345);
        this.writeShort(out, (short)0);
        this.writeShort(out, (short)255);
        this.writeShort(out, (short)7);
        this.writeShort(out, (short)0);
        this.writeShort(out, (short)0);
        this.writeFloat(out, 0.0f);
        this.writeShort(out, (short)0);
        this.writeShort(out, (short)0);
        this.writeShort(out, (short)0);
    }

    void writeFooter(FileInfo fi, OutputStream out) throws IOException {
        out.write(this.formNote("AXIS_2 001 0.000000e+00 " + IJ.d2s((double)fi.pixelWidth, (int)8) + " " + fi.unit, 1, 20));
        out.write(this.formNote("AXIS_3 001 0.000000e+00 " + IJ.d2s((double)fi.pixelHeight, (int)8) + " " + fi.unit, 1, 20));
        if (fi.nImages > 1) {
            out.write(this.formNote("AXIS_4 001 0.000000e+00 " + IJ.d2s((double)fi.pixelDepth, (int)8) + " " + fi.unit, 1, 20));
            out.write(this.formNote("AXIS_9 001 0.000000e+00 1.000000e+00 RGB channel", 0, 20));
        } else {
            out.write(this.formNote("AXIS_4 011 0.000000e+00 1.000000e+00 RGB channel", 0, 20));
        }
    }

    byte[] formNote(String noteText, int noteFlag, int noteType) throws IOException {
        ByteArrayOutputStream line = new ByteArrayOutputStream();
        this.writeShort(line, (short)-1);
        this.writeInt(line, noteFlag);
        this.writeInt(line, 0);
        this.writeShort(line, (short)noteType);
        this.writeInt(line, 0);
        if (noteText.length() < 80) {
            String eightyBlanks = "                                                                                ";
            noteText = noteText + eightyBlanks.substring(noteText.length());
        }
        line.write(noteText.getBytes("ISO-8859-1"));
        return line.toByteArray();
    }

    void writeShort(OutputStream out, short value) throws IOException {
        byte b1 = (byte)(value & 0xFF);
        byte b2 = (byte)(value >> 8 & 0xFF);
        out.write(b1);
        out.write(b2);
    }

    void writeInt(OutputStream out, int value) throws IOException {
        byte b1 = (byte)(value & 0xFF);
        byte b2 = (byte)(value >> 8 & 0xFF);
        byte b3 = (byte)(value >> 16 & 0xFF);
        byte b4 = (byte)(value >> 24 & 0xFF);
        out.write(b1);
        out.write(b2);
        out.write(b3);
        out.write(b4);
    }

    void writeFloat(OutputStream out, float value) throws IOException {
        this.writeInt(out, Float.floatToIntBits(value));
    }
}

