/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.ComputeCurvatures;
import features.GaussianGenerationCallback;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Hessian_CP_Measures
implements PlugIn,
GaussianGenerationCallback {
    public void proportionDone(double d) {
        IJ.showProgress((double)d);
    }

    public void run(String ignore) {
        double minimumSeparation;
        ImagePlus original = IJ.getImage();
        if (original == null) {
            IJ.error((String)"No images open");
            return;
        }
        Calibration calibration = original.getCalibration();
        boolean useCalibration = true;
        float sepX = 1.0f;
        float sepY = 1.0f;
        float sepZ = 1.0f;
        if (useCalibration && calibration != null) {
            sepX = (float)calibration.pixelWidth;
            sepY = (float)calibration.pixelHeight;
            sepZ = (float)calibration.pixelDepth;
        }
        double sigma = minimumSeparation = (double)Math.min(sepX, Math.min(sepY, sepX));
        ComputeCurvatures curvatures = new ComputeCurvatures(original, sigma, (GaussianGenerationCallback)this, useCalibration);
        IJ.showStatus((String)("Convolving with Gaussian \u03c3=" + sigma + " (min. pixel separation: " + minimumSeparation + ")..."));
        curvatures.run();
        int width = original.getWidth();
        int height = original.getHeight();
        int depth = original.getStackSize();
        ImageStack constantStack = new ImageStack(width, height);
        ImageStack traceStack = new ImageStack(width, height);
        ImageStack newTubeStack = new ImageStack(width, height);
        float minConstantResult = Float.MAX_VALUE;
        float maxConstantResult = Float.MIN_VALUE;
        float minTraceResult = Float.MAX_VALUE;
        float maxTraceResult = Float.MIN_VALUE;
        float minNewTubeResult = Float.MAX_VALUE;
        float maxNewTubeResult = Float.MIN_VALUE;
        for (int z = 0; z < depth; ++z) {
            float[] sliceConstant = new float[width * height];
            float[] sliceTrace = new float[width * height];
            float[] sliceNewTube = new float[width * height];
            if (z >= 1 && z < depth - 1) {
                for (int y = 1; y < height - 1; ++y) {
                    for (int x = 1; x < width - 1; ++x) {
                        float[][] m = curvatures.computeHessianMatrix3DFloat(null, x, y, z, sigma, sepX, sepY, sepZ);
                        float a = -1.0f;
                        float b = m[0][0] + m[1][1] + m[2][2];
                        float c = m[0][1] * m[0][1] + m[0][2] * m[0][2] + m[1][2] * m[1][2] - m[0][0] * m[1][1] - m[0][0] * m[2][2] - m[1][1] * m[2][2];
                        float d = m[0][0] * m[1][1] * m[2][2] - m[0][0] * m[1][2] * m[1][2] - m[0][1] * m[0][1] * m[2][2] + 2.0f * m[0][1] * m[0][2] * m[1][2] - m[0][2] * m[0][2] * m[1][1];
                        float newTube = c;
                        float constantValue = Math.abs(d);
                        float traceValue = m[0][0] + m[1][1] + m[2][2];
                        int index = y * width + x;
                        sliceConstant[index] = constantValue;
                        if (constantValue < minConstantResult) {
                            minConstantResult = constantValue;
                        }
                        if (constantValue > maxConstantResult) {
                            maxConstantResult = constantValue;
                        }
                        sliceTrace[index] = traceValue;
                        if (traceValue < minTraceResult) {
                            minTraceResult = traceValue;
                        }
                        if (traceValue > maxTraceResult) {
                            maxTraceResult = traceValue;
                        }
                        sliceNewTube[index] = newTube;
                        if (newTube < minNewTubeResult) {
                            minNewTubeResult = newTube;
                        }
                        if (!(newTube > maxNewTubeResult)) continue;
                        maxNewTubeResult = newTube;
                    }
                }
            }
            FloatProcessor fpConstant = new FloatProcessor(width, height);
            fpConstant.setPixels((Object)sliceConstant);
            constantStack.addSlice(null, (ImageProcessor)fpConstant);
            FloatProcessor fpTrace = new FloatProcessor(width, height);
            fpTrace.setPixels((Object)sliceTrace);
            traceStack.addSlice(null, (ImageProcessor)fpTrace);
            FloatProcessor fpNewTube = new FloatProcessor(width, height);
            fpNewTube.setPixels((Object)sliceNewTube);
            newTubeStack.addSlice(null, (ImageProcessor)fpNewTube);
            IJ.showProgress((double)((double)z / (double)depth));
        }
        IJ.showProgress((double)1.0);
        ImagePlus constantResult = new ImagePlus("abs(constant term) " + original.getTitle(), constantStack);
        constantResult.setCalibration(calibration);
        constantResult.getProcessor().setMinAndMax((double)minConstantResult, (double)maxConstantResult);
        constantResult.updateAndDraw();
        constantResult.show();
        ImagePlus traceResult = new ImagePlus("trace " + original.getTitle(), traceStack);
        traceResult.setCalibration(calibration);
        traceResult.getProcessor().setMinAndMax((double)minTraceResult, (double)maxTraceResult);
        traceResult.updateAndDraw();
        traceResult.show();
        ImagePlus newTubeResult = new ImagePlus("newTube " + original.getTitle(), newTubeStack);
        newTubeResult.setCalibration(calibration);
        newTubeResult.getProcessor().setMinAndMax((double)minNewTubeResult, (double)maxNewTubeResult);
        newTubeResult.updateAndDraw();
        newTubeResult.show();
    }
}

