/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import net.imagej.updater.CheckForUpdates;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdateService;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.util.AvailableSites;
import net.imagej.updater.util.HTTPSUtil;
import org.scijava.app.AppService;
import org.scijava.command.CommandService;
import org.scijava.event.EventHandler;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.prefs.PrefService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.ui.event.UIShownEvent;
import org.scijava.ui.headless.HeadlessUI;
import org.xml.sax.SAXException;

@Plugin(type=Service.class)
public class DefaultUpdateService
extends AbstractService
implements UpdateService {
    private static final String DISABLE_AUTOCHECK_PROPERTY = "imagej.updater.disableAutocheck";
    private static final String LAST_SOFT_CHECK_KEY = "lastSoftCheck";
    private static final long TWENTY_FOUR_HOURS = 86400000L;
    @Parameter
    private CommandService commandService;
    @Parameter
    private AppService appService;
    @Parameter
    private PrefService prefService;
    @Parameter(required=false)
    private LogService log;
    private FilesCollection filesCollection;

    @Override
    public UpdateSite getUpdateSite(String name) {
        FilesCollection fc = this.filesCollection();
        return fc.getUpdateSite(name, true);
    }

    @Override
    public UpdateSite getUpdateSite(File file) {
        String root;
        String path = file.getAbsolutePath();
        if (!path.startsWith(root = this.rootDir().getAbsolutePath() + File.separator)) {
            return null;
        }
        String shortPath = path.substring(root.length());
        FilesCollection fc = this.filesCollection();
        FileObject fileObject = fc.get(shortPath);
        return fc.getUpdateSite(fileObject.updateSite, true);
    }

    @EventHandler
    protected void onEvent(UIShownEvent evt) {
        long lastSoftCheck;
        if (evt.getUI() instanceof HeadlessUI) {
            return;
        }
        if (Boolean.getBoolean(DISABLE_AUTOCHECK_PROPERTY)) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < (lastSoftCheck = this.prefService.getLong(this.getClass(), LAST_SOFT_CHECK_KEY, 0L)) + 86400000L) {
            return;
        }
        this.prefService.put(this.getClass(), LAST_SOFT_CHECK_KEY, now);
        this.commandService.run(CheckForUpdates.class, true, new Object[0]);
    }

    private File rootDir() {
        return this.appService.getApp().getBaseDirectory();
    }

    private FilesCollection filesCollection() {
        if (this.filesCollection == null) {
            this.initFilesCollection();
        }
        return this.filesCollection;
    }

    private synchronized void initFilesCollection() {
        FilesCollection fc;
        block7: {
            if (this.filesCollection != null) {
                return;
            }
            fc = new FilesCollection(this.rootDir());
            HTTPSUtil.checkHTTPSSupport(this.log);
            AvailableSites.initializeAndAddSites(fc);
            try {
                fc.read();
            }
            catch (IOException exc) {
                if (this.log != null) {
                    this.log.error((Object)"Error parsing update sites", (Throwable)exc);
                }
            }
            catch (ParserConfigurationException exc) {
                if (this.log != null) {
                    this.log.error((Object)"Error parsing update sites", (Throwable)exc);
                }
            }
            catch (SAXException exc) {
                if (this.log == null) break block7;
                this.log.error((Object)"Error parsing update sites", (Throwable)exc);
            }
        }
        this.filesCollection = fc;
    }
}

