/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public interface Listeners<T> {
    public boolean add(T var1);

    public boolean add(int var1, T var2);

    public boolean remove(T var1);

    default public boolean addAll(Collection<? extends T> listeners) {
        if (listeners.isEmpty()) {
            return false;
        }
        return listeners.stream().map(this::add).reduce(Boolean::logicalOr).get();
    }

    default public boolean removeAll(Collection<? extends T> listeners) {
        if (listeners.isEmpty()) {
            return false;
        }
        return listeners.stream().map(this::remove).reduce(Boolean::logicalOr).get();
    }

    public static class SynchronizedList<T>
    extends List<T> {
        public SynchronizedList(Consumer<T> onAdd) {
            super(onAdd, new CopyOnWriteArrayList());
        }

        public SynchronizedList() {
            super(o -> {}, new CopyOnWriteArrayList());
        }

        @Override
        public synchronized boolean add(T listener) {
            return super.add(listener);
        }

        @Override
        public synchronized boolean add(int index, T listener) {
            return super.add(index, listener);
        }

        @Override
        public synchronized boolean remove(T listener) {
            return super.remove(listener);
        }

        @Override
        public synchronized ArrayList<T> listCopy() {
            return super.listCopy();
        }
    }

    public static class List<T>
    implements Listeners<T> {
        private final Consumer<T> onAdd;
        public final java.util.List<T> list;

        public List(Consumer<T> onAdd) {
            this(onAdd, new ArrayList());
        }

        public List() {
            this(o -> {});
        }

        protected List(Consumer<T> onAdd, java.util.List<T> list) {
            this.onAdd = onAdd;
            this.list = list;
        }

        @Override
        public boolean add(T listener) {
            if (!this.list.contains(listener)) {
                this.list.add(listener);
                this.onAdd.accept(listener);
                return true;
            }
            return false;
        }

        @Override
        public boolean add(int index, T listener) {
            if (!this.list.contains(listener)) {
                this.list.add(List.clamp(index, 0, this.list.size()), listener);
                this.onAdd.accept(listener);
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(T listener) {
            return this.list.remove(listener);
        }

        public ArrayList<T> listCopy() {
            return new ArrayList<T>(this.list);
        }

        static int clamp(int value, int min, int max) {
            return Math.min(max, Math.max(min, value));
        }
    }
}

