/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.floydsteinberg;

import java.util.Random;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.img.Img;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class FloydSteinbergDithering<T extends RealType<T>>
implements OutputAlgorithm<Img<BitType>>,
Benchmark {
    Img<BitType> result;
    final RandomAccessibleInterval<T> img;
    final Img<FloatType> errorDiffusionKernel;
    final long[] dim;
    final long[] tmp1;
    final long[] tmp2;
    final float ditheringThreshold;
    long processingTime;
    String errorMessage = "";

    public FloydSteinbergDithering(RandomAccessibleInterval<T> img, float ditheringThreshold) {
        this.img = img;
        this.dim = Intervals.dimensionsAsLongArray(img);
        this.tmp1 = new long[img.numDimensions()];
        this.tmp2 = new long[img.numDimensions()];
        this.errorDiffusionKernel = this.createErrorDiffusionKernel(img.numDimensions());
        this.ditheringThreshold = ditheringThreshold;
    }

    public FloydSteinbergDithering(RandomAccessibleInterval<T> img) {
        this(img, Float.NEGATIVE_INFINITY);
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public Img<BitType> getResult() {
        return this.result;
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Img<FloatType> createErrorDiffusionKernel(int numDimensions) {
        int i;
        ArrayImgFactory<FloatType> factory = new ArrayImgFactory<FloatType>(new FloatType());
        if (numDimensions == 2) {
            NativeImg kernel = factory.create(new long[]{3L, 3L});
            RandomAccess cursor = kernel.randomAccess();
            cursor.setPosition(2, 0);
            cursor.setPosition(1, 1);
            ((FloatType)cursor.get()).setReal(0.4375f);
            cursor.move(1, 1);
            ((FloatType)cursor.get()).setReal(0.0625f);
            cursor.move(-1, 0);
            ((FloatType)cursor.get()).setReal(0.3125f);
            cursor.move(-1, 0);
            ((FloatType)cursor.get()).setReal(0.1875f);
            return kernel;
        }
        NativeImg kernel = factory.create(Util.getArrayFromValue(3L, numDimensions));
        RealCursor cursor = kernel.cursor();
        int numValues = (int)(kernel.size() / 2L);
        float[] rndValues = new float[numValues];
        float sum = 0.0f;
        Random rnd = new Random(435345L);
        for (i = 0; i < numValues; ++i) {
            rndValues[i] = rnd.nextFloat();
            sum += rndValues[i];
        }
        i = 0;
        while (i < numValues) {
            int n = i++;
            rndValues[n] = rndValues[n] / sum;
        }
        int count = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            if (count > numValues) {
                ((FloatType)cursor.get()).setReal(rndValues[count - numValues - 1]);
            }
            ++count;
        }
        for (int i2 = 0; i2 < 100; ++i2) {
            for (int d = 0; d < numDimensions; ++d) {
                cursor.reset();
                float sumD = 0.0f;
                while (cursor.hasNext()) {
                    cursor.fwd();
                    if (cursor.getIntPosition(d) == 1) continue;
                    sumD += ((FloatType)cursor.get()).get();
                }
                cursor.reset();
                while (cursor.hasNext()) {
                    cursor.fwd();
                    if (cursor.getIntPosition(d) == 1) continue;
                    ((FloatType)cursor.get()).set(((FloatType)cursor.get()).get() / sumD);
                }
            }
        }
        sum = 0.0f;
        cursor.reset();
        while (cursor.hasNext()) {
            cursor.fwd();
            sum += ((FloatType)cursor.get()).get();
        }
        cursor.reset();
        while (cursor.hasNext()) {
            cursor.fwd();
            ((FloatType)cursor.get()).set(((FloatType)cursor.get()).get() / sum);
        }
        return kernel;
    }
}

