/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler;

import java.io.PrintWriter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.util.TraceClassVisitor;
import org.renjin.compiler.ByteCodeVisitor;
import org.renjin.compiler.CompiledBody;
import org.renjin.compiler.FieldSexpPool;
import org.renjin.compiler.GenerationContext;
import org.renjin.compiler.ThunkMap;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.IRFunctionTable;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.sexp.SEXP;

public class ExpressionCompiler
implements Opcodes {
    private SEXP exp;
    private ClassWriter cw;
    private ClassVisitor cv;
    private GenerationContext generationContext;

    public static Class<CompiledBody> compile(ThunkMap thunkMap, SEXP exp2) {
        return new ExpressionCompiler(thunkMap).doCompile(exp2);
    }

    public ExpressionCompiler(ThunkMap thunkMap) {
        String className = "Body" + System.identityHashCode(this.exp);
        this.generationContext = new GenerationContext(className, new FieldSexpPool(className), thunkMap);
    }

    private Class<CompiledBody> doCompile(SEXP exp2) {
        this.exp = exp2;
        this.startClass();
        this.writeImplementation();
        this.writeConstructor();
        this.generationContext.getSexpPool().writeFields(this.cv);
        this.writeClassEnd();
        return new MyClassLoader().defineClass(this.generationContext.getClassName().replace('/', '.'), this.cw.toByteArray());
    }

    private void startClass() {
        this.cw = new ClassWriter(2);
        this.cv = new TraceClassVisitor((ClassVisitor)this.cw, new PrintWriter(System.out));
        this.cv.visit(50, 33, this.generationContext.getClassName(), null, "java/lang/Object", new String[]{"org/renjin/compiler/CompiledBody"});
    }

    private void writeConstructor() {
        MethodVisitor mv = this.cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(8, l0);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        this.generationContext.getSexpPool().writeConstructorBody(mv);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + this.generationContext.getClassName() + ";", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void writeImplementation() {
        MethodVisitor mv = this.cv.visitMethod(1, "eval", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Environment;)Lorg/renjin/sexp/SEXP;", null, null);
        mv.visitCode();
        this.writeBody(mv);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void writeBody(MethodVisitor mv) {
        IRFunctionTable functionTable = new IRFunctionTable();
        IRBodyBuilder builder = new IRBodyBuilder(functionTable);
        IRBody body2 = builder.build(this.exp);
        ByteCodeVisitor visitor = new ByteCodeVisitor(this.generationContext, mv);
        ControlFlowGraph cfg = new ControlFlowGraph(body2);
        for (BasicBlock bb : cfg.getBasicBlocks()) {
            System.out.println(bb.statementsToString());
            visitor.startBasicBlock(bb);
            for (Statement stmt : bb.getStatements()) {
                stmt.accept(visitor);
            }
        }
    }

    private void writeClassEnd() {
        this.cv.visitEnd();
    }

    class MyClassLoader
    extends ClassLoader {
        MyClassLoader() {
        }

        public Class defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

