/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.renjin.base.BaseFrame;
import org.renjin.eval.EvalException;
import org.renjin.eval.Session;
import org.renjin.eval.SessionBuilder;
import org.renjin.parser.RParser;
import org.renjin.primitives.Warning;
import org.renjin.primitives.packaging.NamespaceRegistry;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.PromisePairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class Context {
    private List<SEXP> onExit = Lists.newArrayList();
    private Context parent;
    private int evaluationDepth;
    private Type type;
    private Environment environment;
    private Session session;
    private FunctionCall call;
    private Closure closure;
    private Environment callingEnvironment;
    private PairList arguments = Null.INSTANCE;
    private Map<String, SEXP> conditionHandlers = Maps.newHashMap();
    private Map<Class, Object> stateMap = null;

    private Context() {
    }

    public static Context newTopLevelContext() {
        return SessionBuilder.buildDefault().getTopLevelContext();
    }

    Context(Session session) {
        this.session = session;
        this.type = Type.TOP_LEVEL;
        this.environment = session.getGlobalEnvironment();
    }

    public Context beginFunction(Environment rho, FunctionCall call2, Closure closure, PairList arguments) {
        Context context = new Context();
        context.type = Type.FUNCTION;
        context.parent = this;
        context.evaluationDepth = this.evaluationDepth + 1;
        context.closure = closure;
        context.environment = Environment.createChildEnvironment(closure.getEnclosingEnvironment());
        context.session = this.session;
        context.arguments = arguments;
        context.call = call2;
        context.callingEnvironment = rho;
        return context;
    }

    public Context beginEvalContext(Environment environment2) {
        Context context = new Context();
        context.type = Type.RETURN;
        context.parent = this;
        context.evaluationDepth = this.evaluationDepth + 1;
        context.environment = environment2;
        context.session = this.session;
        return context;
    }

    public SEXP evaluate(SEXP expression2) {
        return this.evaluate(expression2, this.environment);
    }

    public SEXP materialize(SEXP sexp) {
        if (sexp instanceof DeferredComputation && !((DeferredComputation)sexp).isConstantAccessTime()) {
            return this.session.getVectorEngine().materialize((DeferredComputation)sexp);
        }
        return sexp;
    }

    public SEXP simplify(SEXP sexp) {
        if (sexp instanceof DeferredComputation && ((DeferredComputation)sexp).getComputationDepth() > 25) {
            return this.session.getVectorEngine().simplify((DeferredComputation)sexp);
        }
        return sexp;
    }

    public SEXP evaluate(SEXP expression2, Environment rho) {
        if (expression2 instanceof Symbol) {
            return this.evaluateSymbol((Symbol)expression2, rho);
        }
        if (expression2 instanceof ExpressionVector) {
            return this.evaluateExpressionVector((ExpressionVector)expression2, rho);
        }
        if (expression2 instanceof FunctionCall) {
            return this.evaluateCall((FunctionCall)expression2, rho);
        }
        if (expression2 instanceof Promise) {
            return expression2.force(this);
        }
        if (expression2 != Null.INSTANCE && expression2 instanceof PromisePairList) {
            throw new EvalException("'...' used in an incorrect context", new Object[0]);
        }
        this.clearInvisibleFlag();
        return expression2;
    }

    public <T> T getState(Class<T> clazz) {
        if (this.stateMap != null) {
            return (T)this.stateMap.get(clazz);
        }
        return null;
    }

    public <T> T getSingleton(Class<T> clazz) {
        return this.session.getSingleton(clazz);
    }

    public <T> void setState(T instance) {
        this.setState(instance.getClass(), instance);
    }

    public <T> void setState(Class<T> clazz, T instance) {
        if (this.stateMap == null) {
            this.stateMap = Maps.newHashMap();
        }
        this.stateMap.put(clazz, instance);
    }

    private SEXP evaluateSymbol(Symbol symbol2, Environment rho) {
        this.clearInvisibleFlag();
        if (symbol2 == Symbol.MISSING_ARG) {
            return symbol2;
        }
        SEXP value = rho.findVariable(symbol2);
        if (value == Symbol.UNBOUND_VALUE) {
            throw new EvalException(String.format("object '%s' not found", symbol2.getPrintName()), new Object[0]);
        }
        if (value instanceof Promise) {
            return this.evaluate(value, rho);
        }
        return value;
    }

    private SEXP evaluateExpressionVector(ExpressionVector expressionVector, Environment rho) {
        if (expressionVector.length() == 0) {
            this.setInvisibleFlag();
            return Null.INSTANCE;
        }
        SEXP result = Null.INSTANCE;
        for (SEXP sexp : expressionVector) {
            result = this.evaluate(sexp, rho);
        }
        return result;
    }

    private SEXP evaluateCall(FunctionCall call2, Environment rho) {
        this.clearInvisibleFlag();
        Function functionExpr = this.evaluateFunction(call2.getFunction(), rho);
        return functionExpr.apply(this, rho, call2, call2.getArguments());
    }

    private Function evaluateFunction(SEXP functionExp, Environment rho) {
        if (functionExp instanceof Symbol) {
            Symbol symbol2 = (Symbol)functionExp;
            Function fn = rho.findFunction(this, symbol2);
            if (fn == null) {
                throw new EvalException("could not find function '%s'", symbol2.getPrintName());
            }
            return fn;
        }
        SEXP evaluated = this.evaluate(functionExp, rho).force(this);
        if (!(evaluated instanceof Function)) {
            throw new EvalException("'function' of lang expression is of unsupported type '%s'", evaluated.getTypeName());
        }
        return (Function)evaluated;
    }

    public FileSystemManager getFileSystemManager() {
        return this.session.getFileSystemManager();
    }

    public FileObject resolveFile(String uri) throws FileSystemException {
        return this.getFileSystemManager().resolveFile(this.session.getWorkingDirectory(), uri);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Environment getGlobalEnvironment() {
        return this.session.getGlobalEnvironment();
    }

    public Closure getClosure() {
        return this.closure;
    }

    public PairList getArguments() {
        if (this.type != Type.FUNCTION) {
            throw new IllegalStateException("Only Contexts of type FUNCTION contain a FunctionCall");
        }
        return this.arguments;
    }

    public SEXP getFunctionName() {
        return this.call.getFunction();
    }

    public FunctionCall getCall() {
        return this.call;
    }

    public int getEvaluationDepth() {
        return this.evaluationDepth;
    }

    public int getFrameDepth() {
        int nframe2 = 0;
        Context cptr = this;
        while (!cptr.isTopLevel()) {
            if (cptr.getType() == Type.FUNCTION) {
                ++nframe2;
            }
            cptr = cptr.getParent();
        }
        return nframe2;
    }

    public Context getParent() {
        return this.parent;
    }

    public Session getSession() {
        return this.session;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isTopLevel() {
        return this.parent == null;
    }

    public void setOnExit(SEXP exp2) {
        this.onExit = Lists.newArrayList((Object[])new SEXP[]{exp2});
    }

    public void addOnExit(SEXP exp2) {
        this.onExit.add(exp2);
    }

    public void warn(String message) {
        Warning.emitWarning(this, false, message);
    }

    public void clearOnExits() {
        this.onExit = Lists.newArrayList();
    }

    public void exit() {
        for (SEXP exp2 : this.onExit) {
            this.evaluate(exp2, this.environment);
        }
    }

    public void setConditionHandler(String conditionClass, SEXP function2) {
        this.conditionHandlers.put(conditionClass, function2);
    }

    public SEXP getConditionHandler(String conditionClass) {
        return this.conditionHandlers.get(conditionClass);
    }

    public void init() throws IOException {
        BaseFrame baseFrame = (BaseFrame)this.session.getBaseEnvironment().getFrame();
        baseFrame.load(this);
        this.evaluate(FunctionCall.newCall(Symbol.get(".onLoad"), new SEXP[0]), this.session.getBaseNamespaceEnv());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evalBaseResource(String resourceName) throws IOException {
        Context evalContext = this.beginEvalContext(this.session.getBaseNamespaceEnv());
        InputStream in = this.getClass().getResourceAsStream(resourceName);
        if (in == null) {
            throw new IOException("Could not load resource '" + resourceName + "'");
        }
        try (InputStreamReader reader = new InputStreamReader(in);){
            evalContext.evaluate(RParser.parseSource(reader));
        }
    }

    public void setInvisibleFlag() {
        this.session.invisible = true;
    }

    public void clearInvisibleFlag() {
        this.session.invisible = false;
    }

    public Environment getCallingEnvironment() {
        return this.callingEnvironment;
    }

    public Environment getBaseEnvironment() {
        return this.session.getBaseEnvironment();
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.session.getNamespaceRegistry();
    }

    public static enum Type {
        TOP_LEVEL,
        NEXT,
        BREAK,
        LOOP,
        FUNCTION,
        CCODE,
        RETURN,
        BROWSER,
        GENERIC,
        RESTART,
        BUILTIN;

    }
}

