/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.ClassBinding;
import org.renjin.invoke.reflection.ConstructorBinding;
import org.renjin.invoke.reflection.FieldBinding;
import org.renjin.invoke.reflection.MemberBinding;
import org.renjin.invoke.reflection.MethodBinding;
import org.renjin.invoke.reflection.PropertyBinding;
import org.renjin.invoke.reflection.StaticBinding;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class ClassBindingImpl
implements ClassBinding {
    private static final IdentityHashMap<Class, ClassBindingImpl> TABLE = Maps.newIdentityHashMap();
    private Class clazz;
    private ConstructorBinding constructorBinding;
    private IdentityHashMap<Symbol, MemberBinding> members = Maps.newIdentityHashMap();
    private IdentityHashMap<Symbol, StaticBinding> staticMembers = Maps.newIdentityHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassBindingImpl get(Class clazz) {
        IdentityHashMap<Class, ClassBindingImpl> identityHashMap = TABLE;
        synchronized (identityHashMap) {
            ClassBindingImpl binding = TABLE.get(clazz);
            if (binding == null) {
                binding = new ClassBindingImpl(clazz);
                TABLE.put(clazz, binding);
            }
            return binding;
        }
    }

    private ClassBindingImpl(Class clazz) {
        this.clazz = clazz;
        HashMap getters = Maps.newHashMap();
        ArrayListMultimap setters = ArrayListMultimap.create();
        ArrayListMultimap methods = ArrayListMultimap.create();
        ArrayListMultimap staticMethods = ArrayListMultimap.create();
        for (Method method : clazz.getMethods()) {
            if ((method.getModifiers() & 1) == 0) continue;
            if ((method.getModifiers() & 8) != 0) {
                staticMethods.put((Object)Symbol.get(method.getName()), (Object)method);
                continue;
            }
            methods.put((Object)Symbol.get(method.getName()), (Object)method);
            String propertyName = this.isGetter(method);
            if (propertyName != null) {
                getters.put(Symbol.get(propertyName), method);
                continue;
            }
            propertyName = this.isSetter(method);
            if (propertyName == null) continue;
            setters.put((Object)Symbol.get(propertyName), (Object)method);
        }
        for (Symbol symbol2 : methods.keySet()) {
            this.members.put(symbol2, new MethodBinding(symbol2, methods.get((Object)symbol2)));
        }
        for (Map.Entry entry : getters.entrySet()) {
            Symbol propertySymbol = (Symbol)entry.getKey();
            if (methods.containsKey((Object)propertySymbol)) continue;
            this.members.put(propertySymbol, new PropertyBinding(propertySymbol, (Method)entry.getValue(), setters.get((Object)propertySymbol)));
        }
        for (Symbol symbol3 : staticMethods.keySet()) {
            this.staticMembers.put(symbol3, new StaticBinding(new MethodBinding(symbol3, staticMethods.get((Object)symbol3))));
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (!Modifier.isPublic(((Field)accessibleObject).getModifiers()) || !Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            Symbol name = Symbol.get(((Field)accessibleObject).getName());
            this.staticMembers.put(name, new StaticBinding(new FieldBinding((Field)accessibleObject)));
        }
        this.constructorBinding = new ConstructorBinding(clazz.getConstructors());
    }

    private String isGetter(Method method) {
        if (method.getParameterTypes().length != 0) {
            return null;
        }
        String name = method.getName();
        if (name.startsWith("get") && name.length() > "get".length()) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        if (name.startsWith("is") && name.length() > "is".length()) {
            return name.substring(2, 3).toLowerCase() + name.substring(3);
        }
        return null;
    }

    private String isSetter(Method method) {
        if (method.getParameterTypes().length != 1) {
            return null;
        }
        String name = method.getName();
        if (name.startsWith("set") && name.length() > "set".length()) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        return null;
    }

    public Set<Symbol> getMembers() {
        return this.members.keySet();
    }

    @Override
    public MemberBinding getMemberBinding(Symbol name) {
        MemberBinding memberBinding = this.members.get(name);
        if (memberBinding == null) {
            throw new EvalException("Instance of class %s has no member named '%s'", this.getBoundClass().getName(), name.getPrintName());
        }
        return memberBinding;
    }

    public Set<Symbol> getStaticMembers() {
        return this.staticMembers.keySet();
    }

    public StaticBinding getStaticMember(Symbol name) {
        return this.staticMembers.get(name);
    }

    public StaticBinding getStaticMember(String name) {
        return this.getStaticMember(Symbol.get(name));
    }

    public Object newInstance(Context context, List<SEXP> constructorArgs) {
        return this.constructorBinding.newInstance(context, constructorArgs);
    }

    public Class getBoundClass() {
        return this.clazz;
    }

    public ConstructorBinding getConstructorBinding() {
        return this.constructorBinding;
    }
}

