/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.match;

import org.renjin.primitives.match.DuplicateSearchAlgorithm;
import org.renjin.sexp.Vector;

public class UniqueAlgorithm
implements DuplicateSearchAlgorithm<Vector> {
    private Vector source;
    private boolean[] unique;
    private int uniqueCount;

    @Override
    public void init(Vector source) {
        this.source = source;
        this.unique = new boolean[source.length()];
    }

    @Override
    public void onUnique(int index) {
        this.unique[index] = true;
        ++this.uniqueCount;
    }

    @Override
    public DuplicateSearchAlgorithm.Action onDuplicate(int duplicateIndex, int originalIndex) {
        return DuplicateSearchAlgorithm.Action.CONTINUE;
    }

    @Override
    public Vector getResult() {
        Vector.Builder result = this.source.newBuilderWithInitialCapacity(this.uniqueCount);
        for (int i = 0; i != this.unique.length; ++i) {
            if (!this.unique[i]) continue;
            result.addFrom(this.source, i);
        }
        return result.build();
    }
}

