/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.renjin.eval.EvalException;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;

public final class Symbol
extends AbstractSEXP {
    public static final String TYPE_NAME = "symbol";
    public static final String IMPLICIT_CLASS = "name";
    private static final HashMap<String, Symbol> TABLE;
    public static final Symbol UNBOUND_VALUE;
    public static final Symbol MISSING_ARG;
    private final String printName;
    private final int hashBit;
    private static final int NUM_RESERVED_BITS = 4;

    private static void addReserved(int hashBit, String ... names2) {
        for (String name : names2) {
            TABLE.put(name, new Symbol(name, 1 << hashBit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Symbol get(String printName) {
        if (StringVector.isNA(printName)) {
            return Symbol.get("NA");
        }
        if (printName.length() == 0) {
            throw new EvalException("attempt to use zero-length variable name", new Object[0]);
        }
        HashMap<String, Symbol> hashMap = TABLE;
        synchronized (hashMap) {
            Symbol symbol2 = TABLE.get(printName);
            if (symbol2 == null) {
                symbol2 = new Symbol(printName, Symbol.calcHashBit(printName));
                TABLE.put(printName, symbol2);
            }
            return symbol2;
        }
    }

    private Symbol() {
        this.printName = null;
        this.hashBit = 4;
    }

    private Symbol(String printName, int hashBits) {
        this.printName = printName;
        this.hashBit = hashBits;
    }

    private static int calcHashBit(String printName) {
        int firstChar = printName.codePointAt(0);
        if (firstChar >= 97 && firstChar <= 122) {
            return 1 << firstChar - 97 + 4 + 1;
        }
        return 16;
    }

    public boolean isReservedWord() {
        return this.hashBit == 1;
    }

    @Override
    public String asString() {
        return this.printName;
    }

    public int hashBit() {
        return this.hashBit;
    }

    public int hashCode() {
        return this.hashBit;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public final String getImplicitClass() {
        return IMPLICIT_CLASS;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        this.attributes = attributes2;
        return this;
    }

    public String getPrintName() {
        return this.printName;
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        if (this == UNBOUND_VALUE) {
            return "<unbound>";
        }
        if (this == MISSING_ARG) {
            return "<missing_arg>";
        }
        return this.getPrintName();
    }

    public boolean isVarArgReference() {
        if (this.printName.length() < 3) {
            return false;
        }
        if (this.printName.charAt(0) != '.' || this.printName.charAt(1) != '.') {
            return false;
        }
        for (int i = 2; i != this.printName.length(); ++i) {
            if (Character.isDigit(this.printName.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public int getVarArgReferenceIndex() {
        return Integer.parseInt(this.printName.substring(2));
    }

    static {
        UNBOUND_VALUE = new Symbol();
        MISSING_ARG = new Symbol();
        TABLE = Maps.newHashMap();
        Symbol.addReserved(0, "if", ".Internal", "function", "while", "for", "break", "continue", "repeat", "next", "{", "(", "!", ":", "=", "!=", "==", ">", "<", ">=", "<=", "&", "|", "&&", "||", "+", "-", "*", "/", "^", "<-", "<<-", "[", "[<-", "[[", "[[<-", "$", "$<-", "%*%", "%/%", "%%");
        Symbol.addReserved(1, "paste", "identical", "list", "c", "as.character", "is.character", "as.integer", "is.integer", "is.na", "dim", "is.null", "is.expression", "is.call", "is.numeric", "is.logical", "as.vector", "is.factor", "is.matrix", "is.pairlist", "is.object", "is.function", "is.vector", "is.complex", "is.double", "is.list", "switch", "typeof", "seq_along", "lapply", "sapply", "Encoding<-", "class<-", "names<-", ".subset", ".subset2", "UseMethod", "NextMethod", "sys.call");
        Symbol.addReserved(2, "length", "mode", "length", "any", "attributes", "matrix", "missing", "names", "inherits", "attr", "match", "which");
        Symbol.addReserved(3, "factor", "vector", "integer", "assign", "exists", "mean", "abs", "sum", "all", "any", "oldClass", "data.class", "attr.all.equal", "nargs", "unique", "formals");
    }
}

