/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.ContinuousDistribution;

public class LogisticDistribution
extends AbstractContinuousDistribution
implements ContinuousDistribution {
    double m;
    double s;

    public LogisticDistribution(double m, double s) {
        this.m = m;
        this.s = s;
    }

    public double inverseCumulativeProbability(double p) throws MathException {
        return Math.log(p / (1.0 - p));
    }

    public double cumulativeProbability(double x) throws MathException {
        return 1.0 / (1.0 + Math.exp((this.m - x) / this.s));
    }

    public double cumulativeProbability(double x1, double x2) throws MathException {
        return this.cumulativeProbability(x2) - this.cumulativeProbability(x1);
    }

    protected double getInitialDomain(double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected double getDomainLowerBound(double d) {
        return Double.NEGATIVE_INFINITY;
    }

    protected double getDomainUpperBound(double d) {
        return Double.POSITIVE_INFINITY;
    }

    public double density(double x) throws MathRuntimeException {
        return Math.exp((this.m - x) / this.s) / (this.s * Math.pow(1.0 + Math.exp((this.m - x) / this.s), 2.0));
    }
}

