/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.models;

import com.google.common.collect.Lists;
import java.util.List;
import org.renjin.eval.EvalException;
import org.renjin.primitives.Types;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;
import org.renjin.stats.internals.models.FactorVariable;
import org.renjin.stats.internals.models.Models;
import org.renjin.stats.internals.models.NumericVariable;
import org.renjin.stats.internals.models.Variable;

public class ModelFrame {
    private final ListVector frame;
    private final int numRows;
    private final List<Variable> variables;

    public ModelFrame(ListVector frame2) {
        this.frame = frame2;
        if (frame2.length() == 0) {
            throw new EvalException("do not know how many cases", new Object[0]);
        }
        this.numRows = Models.nrows(frame2.getElementAsSEXP(0));
        this.variables = Lists.newArrayList();
        for (int i = 0; i != frame2.length(); ++i) {
            SEXP vector2 = frame2.getElementAsSEXP(i);
            if (Models.nrows(vector2) != this.numRows) {
                throw new EvalException("variable lengths differ", new Object[0]);
            }
            this.variables.add(this.createVariable(frame2.getName(i), vector2));
        }
    }

    private Variable createVariable(String name, SEXP vector2) {
        if (Types.isFactor(vector2)) {
            return new FactorVariable(name, vector2);
        }
        return new NumericVariable(name, vector2);
    }

    public int getNumRows() {
        return this.numRows;
    }

    public Variable getVariable(int index) {
        return this.variables.get(index);
    }

    public Vector getRowNames() {
        return (Vector)this.frame.getAttribute(Symbols.ROW_NAMES);
    }

    public static int ncols(SEXP s) {
        if (s instanceof Vector) {
            Vector dim2 = (Vector)s.getAttribute(Symbols.DIM);
            if (dim2.length() >= 2) {
                return dim2.getElementAsInt(1);
            }
            return 1;
        }
        if (s.inherits("data.frame")) {
            return s.length();
        }
        throw new EvalException("object is not a matrix", new Object[0]);
    }

    public static boolean isOrderedFactor(SEXP vector2) {
        return vector2 instanceof IntVector && vector2.inherits("factor") && vector2.inherits("ordered");
    }

    public static boolean isUnorderedFactor(SEXP vector2) {
        return vector2 instanceof IntVector && vector2.inherits("factor") && !vector2.inherits("ordered");
    }

    public static int nlevels(SEXP exp2) {
        return exp2.getAttribute(Symbols.LEVELS).length();
    }
}

