/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.imagej.ui.swing.updater.SitesDialog;
import net.imagej.ui.swing.updater.SwingTools;
import net.imagej.ui.swing.updater.UpdaterFrame;
import net.imagej.updater.URLChange;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.util.HTTPSUtil;
import net.miginfocom.swing.MigLayout;

public class ReviewSiteURLsDialog
extends JDialog
implements ActionListener {
    List<URLChange> urlChanges;
    private UpdatableTableDataModel tableModel;
    private JTable table;
    JButton cancel;
    JButton submit;
    JButton ok;
    JRadioButton updateAll;
    JRadioButton keepAll;
    JRadioButton manualChoice;
    JCheckBox stopAsking;
    private ButtonGroup generalChoiceGroup = new ButtonGroup();
    private static final int nameCol = 0;
    private static final int urlCol = 1;
    private static final String appendOld = " (keep URL)";
    private static final String appendNew = " (update URL)";
    private boolean okPressed;

    public ReviewSiteURLsDialog(UpdaterFrame owner, List<URLChange> urlChanges) {
        super((Window)owner, "Changes to Available Update Sites", Dialog.ModalityType.DOCUMENT_MODAL);
        this.urlChanges = urlChanges;
        JPanel contentPane = new JPanel();
        contentPane.setLayout((LayoutManager)new MigLayout("fill, gap 0"));
        this.urlChanges.forEach(change -> change.setApproved(change.isRecommended()));
        if (this.urlChanges.size() > 0) {
            contentPane.add(this.createHeader(), "span, grow");
            contentPane.add(this.createUpdateSiteScrollPane(), "newline, span, grow, push");
            contentPane.add(this.createButtonsPanel(), "dock south");
            this.updateGeneralChoices();
        } else {
            contentPane.add(this.createOkPanel(), "dock south");
            contentPane.add(ReviewSiteURLsDialog.createOkIcon());
            contentPane.add(this.createEverythingIsFineMessage());
        }
        SitesDialog.escapeCancels(this);
        this.setDefaultCloseOperation(2);
        this.setContentPane(contentPane);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    static boolean shouldBeDisplayed(List<URLChange> changes) {
        for (URLChange change : changes) {
            if (!change.isRecommended() || change.isApproved()) continue;
            return true;
        }
        return false;
    }

    boolean isOkPressed() {
        return this.okPressed;
    }

    private Component createEverythingIsFineMessage() {
        JEditorPane text = ReviewSiteURLsDialog.createHTMLText("<html><h3>Software package sources up to date</h3>No updated URLs found for activated update sites.</html>");
        text.setBorder(BorderFactory.createEmptyBorder(10, 10, 20, 25));
        return text;
    }

    private Component createOkPanel() {
        JPanel panel = new JPanel();
        this.ok = new JButton("OK");
        panel.add(this.ok);
        this.ok.addActionListener(this);
        this.getRootPane().setDefaultButton(this.ok);
        return panel;
    }

    private Component createHeader() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("fillx, ins 5px", "[][]push[]"));
        panel.add(ReviewSiteURLsDialog.createUpdatesAvailableMessage(), "span, wrap, wmax 600px");
        panel.add(ReviewSiteURLsDialog.createAttentionIcon(), "w 100px!");
        panel.add(this.createGeneralChoices(), "wrap, w 300px!, bottom, left");
        if (HTTPSUtil.supportsHTTPS()) {
            panel.add(ReviewSiteURLsDialog.createHTTPSInfo(), "wmax 250px, dock east");
        }
        return panel;
    }

    private static Component createAttentionIcon() {
        return new JLabel(UIManager.getIcon("OptionPane.warningIcon"));
    }

    private static Component createOkIcon() {
        JLabel label = new JLabel("<html><h2>:-)</h2>", 0);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return label;
    }

    private static Component createUpdatesAvailableMessage() {
        return ReviewSiteURLsDialog.createHTMLText("<html><h3>Updated software package sources</h3><p>Please review the following update site URL changes.<br/>If you have never heard of update sites, just click <b>OK</b> at the bottom.</p></html>");
    }

    private static Component createHTTPSInfo() {
        JEditorPane text = ReviewSiteURLsDialog.createHTMLText("<html><h3>ImageJ is improving<br/>data security!</h3>From now on ImageJ updates more securely via HTTPS. Therefore addresses of update sites currently in use by your ImageJ installation need to be updated.</html>");
        return text;
    }

    private static JEditorPane createHTMLText(String text) {
        JEditorPane component = new JEditorPane(new HTMLEditorKit().getContentType(), text);
        component.setEditable(false);
        component.setOpaque(false);
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)component.getDocument()).getStyleSheet().addRule(bodyRule);
        return component;
    }

    private Component createGeneralChoices() {
        JPanel generalChoices = new JPanel();
        generalChoices.setLayout((LayoutManager)new MigLayout("flowy, insets n 0 n n", "", ""));
        this.updateAll = this.createGeneralChoiceButton("Update all URLs (recommended)");
        this.keepAll = this.createGeneralChoiceButton("Keep the current URLs");
        this.manualChoice = this.createGeneralChoiceButton("Adjust manually:");
        this.manualChoice.setFont(this.manualChoice.getFont().deriveFont(this.manualChoice.getFont().getStyle() & 0xFFFFFFFE));
        generalChoices.add(this.updateAll);
        generalChoices.add(this.keepAll);
        generalChoices.add(this.manualChoice);
        return generalChoices;
    }

    private JRadioButton createGeneralChoiceButton(String name) {
        JRadioButton btn = new JRadioButton(name);
        this.generalChoiceGroup.add(btn);
        btn.addActionListener(this);
        return btn;
    }

    private Component createButtonsPanel() {
        JPanel buttons = new JPanel();
        buttons.setLayout((LayoutManager)new MigLayout("", "[]push[][]", ""));
        this.stopAsking = new JCheckBox("Remember to not update these URLs");
        buttons.add(this.stopAsking);
        this.cancel = SwingTools.button("Cancel", "Do not update software package sources", this, buttons);
        this.submit = SwingTools.button("OK", "Continue with updated software package sources", this, buttons);
        this.getRootPane().setDefaultButton(this.submit);
        return buttons;
    }

    private Component createUpdateSiteScrollPane() {
        JScrollPane scrollPane = new JScrollPane(this.createUpdatableSitesTable());
        scrollPane.setPreferredSize(new Dimension(this.tableModel.tableWidth, 150));
        return scrollPane;
    }

    private JTable createUpdatableSitesTable() {
        this.tableModel = new UpdatableTableDataModel();
        this.table = new UpdatableSitesTable(this.tableModel);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setRowHeight((int)((double)this.table.getRowHeight() * 1.5));
        this.table.setShowVerticalLines(false);
        ((DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        this.table.setDefaultRenderer(URLChange.class, new URLRenderer());
        TableColumn urlColumn = this.table.getColumnModel().getColumn(1);
        urlColumn.setCellEditor(new URLComboBoxEditor());
        this.tableModel.setColumnWidths();
        return this.table;
    }

    private static String wrapToolTip(String description, String maintainer) {
        if (description == null) {
            return null;
        }
        return "<html><p width='400'>" + description.replaceAll("\n", "<br />") + (maintainer != null ? "</p><p>Maintainer: " + maintainer + "</p>" : "") + "</p></html>";
    }

    private String getUpdateSiteName(int row) {
        return this.getUpdateSite(row).getName();
    }

    private UpdateSite getUpdateSite(int row) {
        return this.getUrlChange(row).updateSite();
    }

    private URLChange getUrlChange(int row) {
        return this.urlChanges.get(row);
    }

    private void updateGeneralChoices() {
        int updated = 0;
        int kept = 0;
        for (URLChange change : this.urlChanges) {
            if (change.isApproved()) {
                ++updated;
                continue;
            }
            ++kept;
        }
        if (kept == 0) {
            this.updateAll.setSelected(true);
        } else if (updated == 0) {
            this.keepAll.setSelected(true);
        } else {
            this.manualChoice.setSelected(true);
        }
        this.stopAsking.setEnabled(kept > 0);
    }

    private void submitAndDispose() {
        this.okPressed = true;
        if (this.stopAsking.isSelected()) {
            this.urlChanges.forEach(change -> {
                if (!change.isApproved()) {
                    change.updateSite().setKeepURL(true);
                }
            });
        }
        super.dispose();
    }

    private void keepAll() {
        this.urlChanges.forEach(change -> change.setApproved(false));
        this.stopAsking.setEnabled(true);
        this.updateTable();
    }

    private void updateAll() {
        this.urlChanges.forEach(change -> change.setApproved(true));
        this.stopAsking.setEnabled(false);
        this.updateTable();
    }

    private void updateTable() {
        this.tableModel.fireTableRowsUpdated(0, this.tableModel.getRowCount() - 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.ok)) {
            super.dispose();
        } else if (e.getSource().equals(this.cancel)) {
            this.dispose();
        } else if (e.getSource().equals(this.submit)) {
            this.submitAndDispose();
        } else if (e.getSource().equals(this.updateAll)) {
            this.updateAll();
        } else if (e.getSource().equals(this.keepAll)) {
            this.keepAll();
        }
    }

    @Override
    public void dispose() {
        this.urlChanges.forEach(change -> change.setApproved(false));
        super.dispose();
    }

    private String keepChoiceString(URLChange site) {
        return "<html><b>" + site.updateSite().getURL() + "</b>" + appendOld;
    }

    private String updateChoiceString(URLChange site) {
        return "<html><b>" + site.getNewURL() + "</b>" + appendNew;
    }

    private class URLPanel
    extends JPanel {
        JLabel urlLabel;
        JLabel choiceLabel;

        URLPanel() {
            this.setLayout((LayoutManager)new MigLayout("fill"));
            this.setOpaque(false);
            this.urlLabel = new JLabel();
            this.choiceLabel = new JLabel();
            this.choiceLabel.setFont(this.choiceLabel.getFont().deriveFont(this.choiceLabel.getFont().getStyle() & 0xFFFFFFFE));
            this.choiceLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
            this.add((Component)this.urlLabel, "dock west");
            this.add((Component)this.choiceLabel, "dock east");
        }

        public void update(URLChange change) {
            this.urlLabel.setText(change.isApproved() ? change.getNewURL() : change.updateSite().getURL());
            this.choiceLabel.setText(change.isApproved() ? ReviewSiteURLsDialog.appendNew : ReviewSiteURLsDialog.appendOld);
        }
    }

    private class URLRenderer
    extends JLabel
    implements TableCellRenderer {
        URLPanel panel;

        private URLRenderer() {
            this.panel = new URLPanel();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            if (value == null) {
                return null;
            }
            this.panel.update((URLChange)value);
            return this.panel;
        }
    }

    private class UpdatableSitesTable
    extends JTable {
        UpdatableSitesTable(UpdatableTableDataModel tableModel) {
            super(tableModel);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column > 0;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            URLChange change = ReviewSiteURLsDialog.this.getUrlChange(row);
            if (column == 1) {
                if (value.equals(ReviewSiteURLsDialog.this.keepChoiceString(change))) {
                    change.setApproved(false);
                }
                if (value.equals(ReviewSiteURLsDialog.this.updateChoiceString(change))) {
                    change.setApproved(true);
                }
                ReviewSiteURLsDialog.this.tableModel.fireTableRowsUpdated(row, row);
                ReviewSiteURLsDialog.this.updateGeneralChoices();
            }
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            UpdateSite site;
            Component component = super.prepareRenderer(renderer, row, column);
            if (component instanceof JComponent && (site = ReviewSiteURLsDialog.this.getUpdateSite(row)) != null) {
                JComponent jcomponent = (JComponent)component;
                jcomponent.setToolTipText(ReviewSiteURLsDialog.wrapToolTip(site.getDescription(), site.getMaintainer()));
            }
            return component;
        }
    }

    private class URLComboBoxEditor
    extends DefaultCellEditor {
        private final JComboBox<String> box;
        private final TableCellEditor editor;

        URLComboBoxEditor() {
            super(new JComboBox());
            this.box = new JComboBox();
            this.editor = new DefaultCellEditor(this.box);
            this.box.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    URLComboBoxEditor.this.stopCellEditing();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    URLComboBoxEditor.this.stopCellEditing();
                }
            });
            this.box.setFont(this.box.getFont().deriveFont(this.box.getFont().getStyle() & 0xFFFFFFFE));
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            URLChange change = ReviewSiteURLsDialog.this.getUrlChange(row);
            this.box.removeAllItems();
            this.box.addItem(ReviewSiteURLsDialog.this.keepChoiceString(change));
            this.box.addItem(ReviewSiteURLsDialog.this.updateChoiceString(change));
            this.box.setSelectedIndex(change.isApproved() ? 1 : 0);
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class UpdatableTableDataModel
    extends DefaultTableModel {
        int tableWidth;
        int[] widths = new int[]{130, 350};
        String[] headers = new String[]{"Name", "Choice"};

        private UpdatableTableDataModel() {
        }

        void setColumnWidths() {
            TableColumnModel columnModel = ReviewSiteURLsDialog.this.table.getColumnModel();
            for (int i = 0; i < ((ReviewSiteURLsDialog)ReviewSiteURLsDialog.this).tableModel.widths.length && i < this.getColumnCount(); ++i) {
                TableColumn column = columnModel.getColumn(i);
                column.setPreferredWidth(((ReviewSiteURLsDialog)ReviewSiteURLsDialog.this).tableModel.widths[i]);
                column.setMinWidth(((ReviewSiteURLsDialog)ReviewSiteURLsDialog.this).tableModel.widths[i]);
                this.tableWidth += ((ReviewSiteURLsDialog)ReviewSiteURLsDialog.this).tableModel.widths[i];
            }
            columnModel.getColumn(0).setMaxWidth(((ReviewSiteURLsDialog)ReviewSiteURLsDialog.this).tableModel.widths[0]);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            return this.headers[column];
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column != 0) {
                return URLChange.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return ReviewSiteURLsDialog.this.urlChanges.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return ReviewSiteURLsDialog.this.getUpdateSiteName(row);
            }
            if (col == 1) {
                return ReviewSiteURLsDialog.this.getUrlChange(row);
            }
            return null;
        }
    }
}

