/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.debug;

import java.net.URL;
import java.util.List;
import java.util.Map;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.Axis;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.display.ColorTables;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.lut.LUTService;
import net.imagej.overlay.Overlay;
import net.imglib2.RandomAccess;
import net.imglib2.display.ColorTable;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.command.InteractiveCommand;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.widget.Button;

@Plugin(type=Command.class, initializer="init", menu={@Menu(label="Plugins", weight=5.0, mnemonic=117), @Menu(label="Sandbox", mnemonic=115), @Menu(label="Mandelbrot Set", mnemonic=109, accelerator="shift ^NUM0")})
public class MandelbrotSetImage
extends InteractiveCommand {
    private static final String NAME = "Mandelbrot Set";
    private static final double CUTOFF = 1.8;
    private static final double DEFAULT_ORIGIN_X = -1.6;
    private static final double DEFAULT_ORIGIN_Y = -1.2;
    private static final double DEFAULT_EXTENT_X = 2.2;
    private static final double DEFAULT_EXTENT_Y = 2.2;
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false)
    private final String msg = "Draw a ROI on the Mandelbrot Set image and press Magnify.";
    @Parameter(label="Reset", callback="reset")
    private Button resetButton;
    @Parameter(label="Magnify", callback="preview")
    private Button magnifyButton;
    @Parameter(type=ItemIO.OUTPUT)
    private ImageDisplay display;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private DisplayService displayService;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private LUTService lutService;
    @Parameter
    private OverlayService overlayService;
    private double originX = -1.6;
    private double originY = -1.2;
    private double extentX = 2.2;
    private double extentY = 2.2;

    public MandelbrotSetImage() {
        super(new String[0]);
    }

    public void preview() {
        Overlay o = this.overlayService.getActiveOverlay(this.display);
        this.setWindow(o);
        this.updateDisplay();
    }

    protected void init() {
        List displays = this.displayService.getDisplays();
        for (Display disp : displays) {
            if (!disp.getName().startsWith(NAME)) continue;
            this.display = (ImageDisplay)disp;
            Overlay o = this.overlayService.getActiveOverlay(this.display);
            this.setWindow(o);
            this.removeOverlays();
            return;
        }
        this.setWindow(null);
        this.display = (ImageDisplay)this.createDisplay();
    }

    protected void reset() {
        this.setWindow(null);
        this.updateDisplay();
    }

    private Display<?> createDisplay() {
        return this.displayService.createDisplay((Object)this.dataset());
    }

    private void updateDisplay() {
        Dataset ds = this.imageDisplayService.getActiveDataset(this.display);
        ImgPlus imgPlus = this.dataset().getImgPlus();
        ds.setImgPlus(imgPlus);
        this.removeOverlays();
    }

    private Dataset dataset() {
        Dataset data = this.makeDataset();
        this.fillDataset(data);
        this.calibrate(data);
        this.applyLUT(data);
        return data;
    }

    private Dataset makeDataset() {
        long SIZE = 768L;
        long[] dims = new long[]{Math.round(768.0 * this.extentX / this.extentY), 768L};
        String name = NAME;
        name = name + " [" + this.originX + "," + this.originY + "] ";
        name = name + " [" + (this.originX + this.extentX) + "," + (this.originY + this.extentY) + "]";
        AxisType[] axes = new AxisType[]{Axes.X, Axes.Y};
        int bitsPerPixel = 8;
        boolean signed = false;
        boolean floating = false;
        return this.datasetService.create(dims, name, axes, 8, false, false);
    }

    private void fillDataset(Dataset ds) {
        RandomAccess accessor = ds.getImgPlus().randomAccess();
        double dx = this.extentX / (double)ds.dimension(0);
        double dy = this.extentY / (double)ds.dimension(1);
        double cx = 0.0;
        long x = 0L;
        while (x < ds.dimension(0)) {
            accessor.setPosition(x, 0);
            double cy = 0.0;
            long y = 0L;
            while (y < ds.dimension(1)) {
                accessor.setPosition(y, 1);
                short value = this.value(this.originX + cx, this.originY + cy);
                ((RealType)accessor.get()).setReal((float)value);
                ++y;
                cy += dy;
            }
            ++x;
            cx += dx;
        }
    }

    private short value(double cx, double cy) {
        short value;
        double zx = cx;
        double zy = cy;
        for (value = 255; value > 0; value = (short)(value - 1)) {
            double tx = zx;
            double ty = zy;
            zx = tx * tx - ty * ty;
            zy = ty * tx + tx * ty;
            if (!(Math.sqrt((zx += cx) * zx + (zy += cy) * zy) > 1.8)) continue;
            return value;
        }
        return value;
    }

    private void applyLUT(Dataset ds) {
        ds.initializeColorTables(1);
        ds.setColorTable(this.lut(), 0);
    }

    private ColorTable lut() {
        Map luts = this.lutService.findLUTs();
        URL lutURL = (URL)luts.get("WCIF/Rainbow RGB.lut");
        if (lutURL != null) {
            try {
                return this.lutService.loadLUT(lutURL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ColorTables.FIRE;
    }

    private void calibrate(Dataset ds) {
        DefaultLinearAxis xAxis = new DefaultLinearAxis(Axes.X, this.extentX / (double)ds.dimension(0), this.originX);
        DefaultLinearAxis yAxis = new DefaultLinearAxis(Axes.Y, this.extentY / (double)ds.dimension(1), this.originY);
        ds.setAxis((Axis)xAxis, 0);
        ds.setAxis((Axis)yAxis, 1);
    }

    private void setWindow(Overlay o) {
        if (o == null) {
            this.originX = -1.6;
            this.originY = -1.2;
            this.extentX = 2.2;
            this.extentY = 2.2;
        } else {
            Dataset ds = this.imageDisplayService.getActiveDataset(this.display);
            CalibratedAxis xAxis = (CalibratedAxis)ds.axis(0);
            CalibratedAxis yAxis = (CalibratedAxis)ds.axis(1);
            this.originX = xAxis.calibratedValue(o.realMin(0));
            this.originY = yAxis.calibratedValue(o.realMin(1));
            double cornerX = xAxis.calibratedValue(o.realMax(0));
            double cornerY = yAxis.calibratedValue(o.realMax(1));
            this.extentX = cornerX - this.originX;
            this.extentY = cornerY - this.originY;
        }
    }

    private void removeOverlays() {
        for (Overlay ovr : this.overlayService.getOverlays(this.display)) {
            this.overlayService.removeOverlay(this.display, ovr);
        }
    }
}

