/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.CachedTargets;

class SwitchState {
    long[] compositeSwitchMask = new long[]{0L};
    boolean cachedSwitchOn = true;
    boolean currentSwitchOn = true;
    boolean lastSwitchOn = true;
    boolean initialized = false;
    CachedTargets cachedTargets = null;
    boolean inSwitch = false;

    public SwitchState(boolean inSwitch) {
        this.inSwitch = inSwitch;
        this.initialized = !inSwitch;
    }

    void dump() {
        System.err.println(" MASK " + this.compositeSwitchMask[0] + " CACH " + this.cachedSwitchOn + " CURR " + this.currentSwitchOn + " LAST " + this.lastSwitchOn);
    }

    void updateCompositeSwitchMask(int switchLevel, boolean switchOn) {
        if (switchLevel < 64) {
            this.compositeSwitchMask[0] = switchOn ? this.compositeSwitchMask[0] & (long)(~(1 << switchLevel)) : this.compositeSwitchMask[0] | (long)(1 << switchLevel);
        } else {
            int index = switchLevel / 64;
            int offset = switchLevel % 64;
            if (index > this.compositeSwitchMask.length) {
                long[] newCompositeSwitchMask = new long[index + 1];
                System.arraycopy(this.compositeSwitchMask, 0, newCompositeSwitchMask, 0, index);
                this.compositeSwitchMask = newCompositeSwitchMask;
            }
            if (switchOn) {
                int n = index;
                this.compositeSwitchMask[n] = this.compositeSwitchMask[n] & (long)(~(1 << offset));
            } else {
                int n = index;
                this.compositeSwitchMask[n] = this.compositeSwitchMask[n] | (long)(1 << offset);
            }
        }
    }

    void initSwitchOn() {
        boolean switchOn;
        this.lastSwitchOn = this.cachedSwitchOn = (switchOn = this.evalCompositeSwitchOn());
        this.currentSwitchOn = this.cachedSwitchOn;
        this.initialized = true;
    }

    void updateCurrentSwitchOn() {
        this.currentSwitchOn = !this.currentSwitchOn;
    }

    void updateLastSwitchOn() {
        this.lastSwitchOn = this.currentSwitchOn;
    }

    void updateCachedSwitchOn() {
        this.cachedSwitchOn = !this.cachedSwitchOn;
    }

    boolean evalCompositeSwitchOn() {
        boolean switchOn;
        if (this.compositeSwitchMask.length == 1) {
            switchOn = this.compositeSwitchMask[0] == 0L;
        } else {
            switchOn = true;
            for (int i = 0; i < this.compositeSwitchMask.length; ++i) {
                if (this.compositeSwitchMask[i] == 0L) continue;
                switchOn = false;
                break;
            }
        }
        return switchOn;
    }
}

