/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.transforms;

import net.imglib2.Interval;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.img.cell.CellCursor;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.LinearSpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.ParametrizedTransform;

public abstract class AbstractLinearSpatialTransform<P>
implements LinearSpatialTransform,
ParametrizedTransform<AffineGet, P> {
    public final String type;
    private final String parameterPath;

    public AbstractLinearSpatialTransform(String type) {
        this(type, null);
    }

    public AbstractLinearSpatialTransform(String type, String parameterPath) {
        this.type = type;
        this.parameterPath = parameterPath;
    }

    @Override
    public String getParameterPath() {
        return this.parameterPath;
    }

    @Override
    public abstract AffineGet getTransform();

    protected static <T extends RealType<T> & NativeType<T>> double[] getDoubleArray(N5Reader n5, String path) {
        if (n5.exists(path)) {
            try {
                CachedCellImg data = N5Utils.open((N5Reader)n5, (String)path);
                if (data.numDimensions() != 1 || !(Util.getTypeFromInterval((Interval)data) instanceof RealType)) {
                    return null;
                }
                double[] params = new double[(int)data.dimension(0)];
                CellCursor c = data.cursor();
                int i = 0;
                while (c.hasNext()) {
                    params[i++] = ((RealType)c.next()).getRealDouble();
                }
                return params;
            }
            catch (N5Exception n5Exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected static <T extends RealType<T> & NativeType<T>> double[][] getDoubleArray2(N5Reader n5, String path) {
        if (n5.exists(path)) {
            try {
                CachedCellImg data = N5Utils.open((N5Reader)n5, (String)path);
                if (data.numDimensions() != 2 || !(Util.getTypeFromInterval((Interval)data) instanceof RealType)) {
                    return null;
                }
                double[][] params = new double[(int)data.dimension(0)][(int)data.dimension(1)];
                CellCursor c = data.cursor();
                while (c.hasNext()) {
                    c.fwd();
                    params[c.getIntPosition((int)0)][c.getIntPosition((int)1)] = ((RealType)c.get()).getRealDouble();
                }
                return params;
            }
            catch (N5Exception n5Exception) {
                // empty catch block
            }
        }
        return null;
    }
}

