/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Fft;
import edu.mines.jtk.dsp.RecursiveExponentialFilter;
import edu.mines.jtk.dsp.RecursiveGaussianFilter;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.util.ArrayMath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RecursiveExponentialFilterTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(RecursiveExponentialFilterTest.class);
        TestRunner.run((Test)suite);
    }

    public void testInPlace() {
        int n1 = 101;
        int n2 = 102;
        int n3 = 103;
        float[] x1 = ArrayMath.randfloat(n1);
        float[] y1 = new float[n1];
        float[] z1 = new float[n1];
        float[][] x2 = ArrayMath.randfloat(n1, n2);
        float[][] y2 = new float[n2][n1];
        float[][] z2 = new float[n2][n1];
        float[][][] x3 = ArrayMath.randfloat(n1, n2, n3);
        float[][][] y3 = new float[n3][n2][n1];
        float[][][] z3 = new float[n3][n2][n1];
        RecursiveExponentialFilter.Edges[] edgesAll = new RecursiveExponentialFilter.Edges[]{RecursiveExponentialFilter.Edges.INPUT_ZERO_VALUE, RecursiveExponentialFilter.Edges.OUTPUT_ZERO_VALUE, RecursiveExponentialFilter.Edges.INPUT_ZERO_SLOPE, RecursiveExponentialFilter.Edges.OUTPUT_ZERO_SLOPE};
        RecursiveExponentialFilter ref = new RecursiveExponentialFilter(40.0);
        for (RecursiveExponentialFilter.Edges edges : edgesAll) {
            ref.setEdges(edges);
            ArrayMath.copy(x1, z1);
            ref.apply(x1, y1);
            ref.apply(z1, z1);
            this.assertEqual(y1, z1);
            ArrayMath.copy(x2, z2);
            ref.apply(x2, y2);
            ref.apply(z2, z2);
            this.assertEqual(y2, z2);
            ArrayMath.copy(x3, z3);
            ref.apply(x3, y3);
            ref.apply(z3, z3);
            this.assertEqual(y3, z3);
        }
    }

    public void testFrequencyResponse() {
        int n = 501;
        double sigma = 4.0;
        float[] x = new float[n];
        x[n / 2] = 1.0f;
        float[] ye = new float[n];
        float[] yg = new float[n];
        RecursiveExponentialFilter ref = new RecursiveExponentialFilter(sigma);
        RecursiveGaussianFilter rgf = new RecursiveGaussianFilter(sigma);
        ref.apply(x, ye);
        rgf.apply0(x, yg);
        Fft fft = new Fft(n);
        fft.setCenter(true);
        Sampling sf = fft.getFrequencySampling1();
        int i0 = sf.indexOfNearest(0.0);
        float[] ae = ArrayMath.cabs(fft.applyForward(ye));
        float[] ag = ArrayMath.cabs(fft.applyForward(yg));
        float e0 = ae[i0];
        float e1 = (ae[i0 + 1] - ae[i0 - 1]) / 2.0f;
        float e2 = ae[i0 + 1] - 2.0f * ae[i0] + ae[i0 - 1];
        float g0 = ag[i0];
        float g1 = (ag[i0 + 1] - ag[i0 - 1]) / 2.0f;
        float g2 = ag[i0 + 1] - 2.0f * ag[i0] + ag[i0 - 1];
        RecursiveExponentialFilterTest.assertEquals((double)e0, (double)g0, (double)1.0E-4);
        RecursiveExponentialFilterTest.assertEquals((double)e1, (double)g1, (double)1.0E-4);
        RecursiveExponentialFilterTest.assertEquals((double)e2, (double)g2, (double)(0.01 * (double)ArrayMath.abs(g2)));
    }

    public void testSpd() {
        RecursiveExponentialFilter.Edges[] edgesAll;
        for (RecursiveExponentialFilter.Edges edges : edgesAll = new RecursiveExponentialFilter.Edges[]{RecursiveExponentialFilter.Edges.INPUT_ZERO_VALUE, RecursiveExponentialFilter.Edges.OUTPUT_ZERO_VALUE, RecursiveExponentialFilter.Edges.INPUT_ZERO_SLOPE, RecursiveExponentialFilter.Edges.OUTPUT_ZERO_SLOPE}) {
            RecursiveExponentialFilterTest.testSpd1(edges);
            RecursiveExponentialFilterTest.testSpd2(edges);
            RecursiveExponentialFilterTest.testSpd3(edges);
        }
    }

    private static void testSpd1(RecursiveExponentialFilter.Edges edges) {
        int n1 = 201;
        float[] x = ArrayMath.sub(ArrayMath.randfloat(n1), 0.5f);
        float[] y = ArrayMath.sub(ArrayMath.randfloat(n1), 0.5f);
        float[] ax = new float[n1];
        float[] ay = new float[n1];
        RecursiveExponentialFilter ref = new RecursiveExponentialFilter((double)n1 / 5.0);
        ref.setEdges(edges);
        ref.apply(x, ax);
        ref.apply(y, ay);
        float yax = ArrayMath.sum(ArrayMath.mul(y, ax));
        float xay = ArrayMath.sum(ArrayMath.mul(x, ay));
        float xax = ArrayMath.sum(ArrayMath.mul(x, ax));
        float yay = ArrayMath.sum(ArrayMath.mul(y, ay));
        float tol = 1.1920929E-5f;
        if (edges == RecursiveExponentialFilter.Edges.INPUT_ZERO_SLOPE) {
            float err = ArrayMath.abs(xay - yax);
            RecursiveExponentialFilterTest.assertTrue((err > tol ? 1 : 0) != 0);
        } else {
            RecursiveExponentialFilterTest.assertTrue((xax > 0.0f ? 1 : 0) != 0);
            RecursiveExponentialFilterTest.assertTrue((yay > 0.0f ? 1 : 0) != 0);
            RecursiveExponentialFilterTest.assertEquals((float)xay, (float)yax, (float)tol);
        }
    }

    private static void testSpd2(RecursiveExponentialFilter.Edges edges) {
        int n1 = 201;
        int n2 = 203;
        float[][] x = ArrayMath.sub(ArrayMath.randfloat(n1, n2), 0.5f);
        float[][] y = ArrayMath.sub(ArrayMath.randfloat(n1, n2), 0.5f);
        float[][] ax = new float[n2][n1];
        float[][] ay = new float[n2][n1];
        RecursiveExponentialFilter ref = new RecursiveExponentialFilter((double)n1 / 5.0);
        ref.setEdges(edges);
        ref.apply(x, ax);
        ref.apply(y, ay);
        float yax = ArrayMath.sum(ArrayMath.mul(y, ax));
        float xay = ArrayMath.sum(ArrayMath.mul(x, ay));
        float xax = ArrayMath.sum(ArrayMath.mul(x, ax));
        float yay = ArrayMath.sum(ArrayMath.mul(y, ay));
        float tol = 1.1920929E-5f;
        if (edges == RecursiveExponentialFilter.Edges.INPUT_ZERO_SLOPE) {
            float err = ArrayMath.abs(xay - yax);
            RecursiveExponentialFilterTest.assertTrue((err > tol ? 1 : 0) != 0);
        } else {
            RecursiveExponentialFilterTest.assertTrue((xax > 0.0f ? 1 : 0) != 0);
            RecursiveExponentialFilterTest.assertTrue((yay > 0.0f ? 1 : 0) != 0);
            RecursiveExponentialFilterTest.assertEquals((float)xay, (float)yax, (float)tol);
        }
    }

    private static void testSpd3(RecursiveExponentialFilter.Edges edges) {
        int n1 = 101;
        int n2 = 103;
        int n3 = 105;
        float[][][] x = ArrayMath.sub(ArrayMath.randfloat(n1, n2, n3), 0.5f);
        float[][][] y = ArrayMath.sub(ArrayMath.randfloat(n1, n2, n3), 0.5f);
        float[][][] ax = new float[n3][n2][n1];
        float[][][] ay = new float[n3][n2][n1];
        RecursiveExponentialFilter ref = new RecursiveExponentialFilter((double)n1 / 5.0);
        ref.setEdges(edges);
        ref.apply(x, ax);
        ref.apply(y, ay);
        float yax = ArrayMath.sum(ArrayMath.mul(y, ax));
        float xay = ArrayMath.sum(ArrayMath.mul(x, ay));
        float xax = ArrayMath.sum(ArrayMath.mul(x, ax));
        float yay = ArrayMath.sum(ArrayMath.mul(y, ay));
        float tol = 1.1920929E-5f;
        if (edges == RecursiveExponentialFilter.Edges.INPUT_ZERO_SLOPE) {
            float err = ArrayMath.abs(xay - yax);
            RecursiveExponentialFilterTest.assertTrue((err > tol ? 1 : 0) != 0);
        } else {
            RecursiveExponentialFilterTest.assertTrue((xax > 0.0f ? 1 : 0) != 0);
            RecursiveExponentialFilterTest.assertTrue((yay > 0.0f ? 1 : 0) != 0);
            RecursiveExponentialFilterTest.assertEquals((float)xay, (float)yax, (float)tol);
        }
    }

    private void assertEqual(float[] e, float[] a) {
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            RecursiveExponentialFilterTest.assertEquals((double)e[i], (double)a[i], (double)0.0);
        }
    }

    private void assertEqual(float[][] e, float[][] a) {
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            this.assertEqual(e[i], a[i]);
        }
    }

    private void assertEqual(float[][][] e, float[][][] a) {
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            this.assertEqual(e[i], a[i]);
        }
    }
}

