/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Recursive2ndOrderFilter;
import edu.mines.jtk.util.Cdouble;
import edu.mines.jtk.util.Check;

public class RecursiveParallelFilter {
    private int _np;
    private int _nz;
    private int _nc;
    private int _nr;
    private float _c;
    private float _g;
    private int _n1;
    private int _n2;
    private Recursive2ndOrderFilter[] _f1;
    private Recursive2ndOrderFilter[] _f2;

    public RecursiveParallelFilter(Cdouble[] poles, Cdouble[] zeros, double gain) {
        this.init(poles, zeros, gain);
    }

    public void applyForward(float[] x, float[] y) {
        RecursiveParallelFilter.scale(this._c, x, y);
        for (int i1 = 0; i1 < this._n1; ++i1) {
            this._f1[i1].accumulateForward(x, y);
        }
    }

    public void applyReverse(float[] x, float[] y) {
        RecursiveParallelFilter.scale(this._c, x, y);
        for (int i1 = 0; i1 < this._n1; ++i1) {
            this._f1[i1].accumulateReverse(x, y);
        }
    }

    public void applyForwardReverse(float[] x, float[] y) {
        RecursiveParallelFilter.scale(this._c * this._g, x, y);
        for (int i2 = 0; i2 < this._n2; i2 += 2) {
            this._f2[i2].accumulateForward(x, y);
            this._f2[i2 + 1].accumulateReverse(x, y);
        }
    }

    public void apply1Forward(float[][] x, float[][] y) {
        RecursiveParallelFilter.scale(this._c, x, y);
        for (int i1 = 0; i1 < this._n1; ++i1) {
            this._f1[i1].accumulate1Forward(x, y);
        }
    }

    public void apply1Reverse(float[][] x, float[][] y) {
        RecursiveParallelFilter.scale(this._c, x, y);
        for (int i1 = 0; i1 < this._n1; ++i1) {
            this._f1[i1].accumulate1Reverse(x, y);
        }
    }

    public void apply1ForwardReverse(float[][] x, float[][] y) {
        RecursiveParallelFilter.scale(this._c * this._g, x, y);
        for (int i2 = 0; i2 < this._n2; i2 += 2) {
            this._f2[i2].accumulate1Forward(x, y);
            this._f2[i2 + 1].accumulate1Reverse(x, y);
        }
    }

    public void apply2Forward(float[][] x, float[][] y) {
        RecursiveParallelFilter.scale(this._c, x, y);
        for (int i1 = 0; i1 < this._n1; ++i1) {
            this._f1[i1].accumulate2Forward(x, y);
        }
    }

    public void apply2Reverse(float[][] x, float[][] y) {
        RecursiveParallelFilter.scale(this._c, x, y);
        for (int i1 = 0; i1 < this._n1; ++i1) {
            this._f1[i1].accumulate2Reverse(x, y);
        }
    }

    public void apply2ForwardReverse(float[][] x, float[][] y) {
        RecursiveParallelFilter.scale(this._c * this._g, x, y);
        for (int i2 = 0; i2 < this._n2; i2 += 2) {
            this._f2[i2].accumulate2Forward(x, y);
            this._f2[i2 + 1].accumulate2Reverse(x, y);
        }
    }

    public void apply1Forward(float[][][] x, float[][][] y) {
        RecursiveParallelFilter.scale(this._c, x, y);
        for (int i1 = 0; i1 < this._n1; ++i1) {
            this._f1[i1].accumulate1Forward(x, y);
        }
    }

    public void apply1Reverse(float[][][] x, float[][][] y) {
        RecursiveParallelFilter.scale(this._c, x, y);
        for (int i1 = 0; i1 < this._n1; ++i1) {
            this._f1[i1].accumulate1Reverse(x, y);
        }
    }

    public void apply1ForwardReverse(float[][][] x, float[][][] y) {
        RecursiveParallelFilter.scale(this._c * this._g, x, y);
        for (int i2 = 0; i2 < this._n2; i2 += 2) {
            this._f2[i2].accumulate1Forward(x, y);
            this._f2[i2 + 1].accumulate1Reverse(x, y);
        }
    }

    public void apply2Forward(float[][][] x, float[][][] y) {
        RecursiveParallelFilter.scale(this._c, x, y);
        for (int i1 = 0; i1 < this._n1; ++i1) {
            this._f1[i1].accumulate2Forward(x, y);
        }
    }

    public void apply2Reverse(float[][][] x, float[][][] y) {
        RecursiveParallelFilter.scale(this._c, x, y);
        for (int i1 = 0; i1 < this._n1; ++i1) {
            this._f1[i1].accumulate2Reverse(x, y);
        }
    }

    public void apply2ForwardReverse(float[][][] x, float[][][] y) {
        RecursiveParallelFilter.scale(this._c * this._g, x, y);
        for (int i2 = 0; i2 < this._n2; i2 += 2) {
            this._f2[i2].accumulate2Forward(x, y);
            this._f2[i2 + 1].accumulate2Reverse(x, y);
        }
    }

    public void apply3Forward(float[][][] x, float[][][] y) {
        RecursiveParallelFilter.scale(this._c, x, y);
        for (int i1 = 0; i1 < this._n1; ++i1) {
            this._f1[i1].accumulate3Forward(x, y);
        }
    }

    public void apply3Reverse(float[][][] x, float[][][] y) {
        RecursiveParallelFilter.scale(this._c, x, y);
        for (int i1 = 0; i1 < this._n1; ++i1) {
            this._f1[i1].accumulate3Reverse(x, y);
        }
    }

    public void apply3ForwardReverse(float[][][] x, float[][][] y) {
        RecursiveParallelFilter.scale(this._c * this._g, x, y);
        for (int i2 = 0; i2 < this._n2; i2 += 2) {
            this._f2[i2].accumulate3Forward(x, y);
            this._f2[i2 + 1].accumulate3Reverse(x, y);
        }
    }

    public void applyFrf(float[] x, float[] y) {
        RecursiveParallelFilter.scale(this._c * this._g, x, y);
        for (int i2 = 0; i2 < this._n2; i2 += 2) {
            this._f2[i2].accumulateForward(x, y);
        }
    }

    public void applyFrr(float[] x, float[] y) {
        RecursiveParallelFilter.scale(this._c * this._g, x, y);
        for (int i2 = 0; i2 < this._n2; i2 += 2) {
            this._f2[i2 + 1].accumulateReverse(x, y);
        }
    }

    protected RecursiveParallelFilter() {
    }

    protected void init(Cdouble[] poles, Cdouble[] zeros, double gain) {
        poles = RecursiveParallelFilter.nonZero(poles);
        Check.argument((zeros = RecursiveParallelFilter.nonZero(zeros)).length <= poles.length, "number of non-zero zeros does not exceed number of non-zero poles");
        Check.argument(RecursiveParallelFilter.polesUnique(poles), "all poles are unique");
        this._np = poles.length;
        this._nz = zeros.length;
        poles = RecursiveParallelFilter.sort(poles);
        zeros = RecursiveParallelFilter.sort(zeros);
        this._nc = 0;
        this._nr = 0;
        for (int ip = 0; ip < this._np; ++ip) {
            if (poles[ip].i != 0.0) {
                ++this._nc;
                continue;
            }
            ++this._nr;
        }
        this._n1 = this._nr + this._nc / 2;
        this._n2 = 2 * this._n1;
        this._f1 = new Recursive2ndOrderFilter[this._n1];
        this._f2 = new Recursive2ndOrderFilter[this._n2];
        double c = this._nz == this._np ? gain : 0.0;
        int i1 = 0;
        int i2 = 0;
        int jp = 0;
        while (i1 < this._n1) {
            double rb2;
            double rb1;
            double rb0;
            double fb2;
            double fb1;
            double fb0;
            double b2;
            double b1;
            double b0;
            double a2;
            double a1;
            Cdouble pj = poles[jp];
            Cdouble hi = this.hi(pj, poles, zeros, gain);
            Cdouble hj = this.hr(pj, poles, zeros, gain);
            Cdouble hihj = hi.times(hj);
            if (pj.i == 0.0) {
                a1 = -pj.r;
                a2 = 0.0;
                b0 = hj.r;
                b1 = 0.0;
                b2 = 0.0;
                fb0 = hihj.r;
                fb1 = 0.0;
                fb2 = 0.0;
                rb0 = 0.0;
                rb1 = -fb0 * a1;
                rb2 = 0.0;
            } else {
                ++jp;
                Cdouble qj = pj.inv();
                a1 = -2.0 * pj.r;
                a2 = pj.norm();
                b0 = hj.r - hj.i * qj.r / qj.i;
                b1 = hj.i / qj.i;
                b2 = 0.0;
                fb0 = hihj.r - hihj.i * qj.r / qj.i;
                fb1 = hihj.i / qj.i;
                fb2 = 0.0;
                rb0 = 0.0;
                rb1 = fb1 - fb0 * a1;
                rb2 = -fb0 * a2;
            }
            this._f1[i1++] = RecursiveParallelFilter.makeFilter(b0, b1, b2, a1, a2);
            this._f2[i2++] = RecursiveParallelFilter.makeFilter(fb0, fb1, fb2, a1, a2);
            this._f2[i2++] = RecursiveParallelFilter.makeFilter(rb0, rb1, rb2, a1, a2);
            if (this._nz == this._np) {
                c -= b0;
            }
            ++jp;
        }
        this._c = (float)c;
        this._g = (float)gain;
    }

    private static Recursive2ndOrderFilter makeFilter(double b0, double b1, double b2, double a1, double a2) {
        return new Recursive2ndOrderFilter((float)b0, (float)b1, (float)b2, (float)a1, (float)a2);
    }

    private Cdouble hi(Cdouble z, Cdouble[] poles, Cdouble[] zeros, double gain) {
        Cdouble c1 = new Cdouble(1.0, 0.0);
        Cdouble hz = new Cdouble(c1);
        for (int iz = 0; iz < this._nz; ++iz) {
            Cdouble zi = zeros[iz];
            hz.timesEquals(c1.minus(zi.times(z)));
        }
        Cdouble hp = new Cdouble(c1);
        for (int ip = 0; ip < this._np; ++ip) {
            Cdouble pi = poles[ip];
            hp.timesEquals(c1.minus(pi.times(z)));
        }
        return hz.over(hp).times(gain);
    }

    private Cdouble hr(Cdouble polej, Cdouble[] poles, Cdouble[] zeros, double gain) {
        Cdouble pj = polej;
        Cdouble qj = pj.inv();
        Cdouble c1 = new Cdouble(1.0, 0.0);
        Cdouble hz = new Cdouble(c1);
        for (int iz = 0; iz < this._nz; ++iz) {
            Cdouble zi = zeros[iz];
            hz.timesEquals(c1.minus(zi.times(qj)));
        }
        Cdouble hp = new Cdouble(c1);
        for (int ip = 0; ip < this._np; ++ip) {
            Cdouble pi = poles[ip];
            if (pi.equals(pj) || pi.equals(pj.conj())) continue;
            hp.timesEquals(c1.minus(pi.times(qj)));
        }
        return hz.over(hp).times(gain);
    }

    private static boolean polesUnique(Cdouble[] poles) {
        int np = poles.length;
        for (int ip = 0; ip < np; ++ip) {
            Cdouble pi = poles[ip];
            for (int jp = ip + 1; jp < np; ++jp) {
                Cdouble pj = poles[jp];
                if (!pi.equals(pj)) continue;
                return false;
            }
        }
        return true;
    }

    private static Cdouble[] nonZero(Cdouble[] c) {
        int n = c.length;
        int m = 0;
        for (int i = 0; i < n; ++i) {
            if (c[i].r == 0.0 && c[i].i == 0.0) continue;
            ++m;
        }
        Cdouble[] d = new Cdouble[m];
        m = 0;
        for (int i = 0; i < n; ++i) {
            if (c[i].r == 0.0 && c[i].i == 0.0) continue;
            d[m++] = c[i];
        }
        return d;
    }

    private static Cdouble[] sort(Cdouble[] c) {
        int i;
        int n = c.length;
        Cdouble[] cs = new Cdouble[n];
        int ns = 0;
        for (i = 0; i < n; ++i) {
            int j;
            if (c[i].isReal()) continue;
            Cdouble cc = c[i].conj();
            for (j = 0; j < n && !cc.equals(c[j]); ++j) {
            }
            Check.argument(j < n, "complex " + c[i] + " has a conjugate mate");
            if (i >= j) continue;
            cs[ns++] = c[i];
            cs[ns++] = c[j];
        }
        for (i = 0; i < n; ++i) {
            if (!c[i].isReal()) continue;
            cs[ns++] = c[i];
        }
        return cs;
    }

    private static void scale(float s, float[] x, float[] y) {
        int n1 = y.length;
        for (int i1 = 0; i1 < n1; ++i1) {
            y[i1] = s * x[i1];
        }
    }

    private static void scale(float s, float[][] x, float[][] y) {
        int n2 = y.length;
        int n1 = y[0].length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] x2 = x[i2];
            float[] y2 = y[i2];
            for (int i1 = 0; i1 < n1; ++i1) {
                y2[i1] = s * x2[i1];
            }
        }
    }

    private static void scale(float s, float[][][] x, float[][][] y) {
        int n3 = y.length;
        int n2 = y[0].length;
        int n1 = y[0][0].length;
        for (int i3 = 0; i3 < n3; ++i3) {
            float[][] x3 = x[i3];
            float[][] y3 = y[i3];
            for (int i2 = 0; i2 < n2; ++i2) {
                float[] x32 = x3[i2];
                float[] y32 = y3[i2];
                for (int i1 = 0; i1 < n1; ++i1) {
                    y32[i1] = s * x32[i1];
                }
            }
        }
    }
}

