/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.ColorState;
import edu.mines.jtk.sgl.LightModelState;
import edu.mines.jtk.sgl.MaterialState;
import edu.mines.jtk.sgl.OrbitView;
import edu.mines.jtk.sgl.PointGroup;
import edu.mines.jtk.sgl.StateSet;
import edu.mines.jtk.sgl.TestFrame;
import edu.mines.jtk.sgl.World;
import java.awt.Color;
import java.awt.Dimension;

public class PointGroupTest {
    public static void main(String[] args) {
        float[] xyz = PointGroupTest.makeSineWave();
        xyz = PointGroupTest.addBulge(xyz);
        float[] rgb = PointGroupTest.makeColors(xyz);
        PointGroup pg = new PointGroup(0.05f, xyz, rgb);
        System.out.println("PointGroup bounding sphere =\n" + pg.getBoundingSphere(true));
        StateSet states = new StateSet();
        ColorState cs = new ColorState();
        cs.setColor(Color.CYAN);
        states.add(cs);
        LightModelState lms = new LightModelState();
        lms.setTwoSide(true);
        states.add(lms);
        MaterialState ms = new MaterialState();
        ms.setColorMaterial(5634);
        ms.setSpecular(Color.white);
        ms.setShininess(100.0f);
        states.add(ms);
        pg.setStates(states);
        World world = new World();
        world.addChild(pg);
        TestFrame frame = new TestFrame(world);
        OrbitView view = frame.getOrbitView();
        view.setWorldSphere(new BoundingSphere(5.0, 5.0, 5.0, 5.0));
        frame.setSize(new Dimension(800, 600));
        frame.setVisible(true);
    }

    private static float[] makeSineWave() {
        int nx = 100;
        int ny = 100;
        float dx = 10.0f / (float)nx;
        float dy = 10.0f / (float)ny;
        float[] xyz = new float[3 * nx * ny];
        int i = 0;
        for (int ix = 0; ix < nx; ++ix) {
            float xi = (float)ix * dx;
            for (int iy = 0; iy < ny; ++iy) {
                float yi = (float)iy * dy;
                xyz[i++] = xi;
                xyz[i++] = yi;
                xyz[i++] = PointGroupTest.sin(xi, yi);
            }
        }
        return xyz;
    }

    private static float sin(float x, float y) {
        return (float)(5.0 + 0.25 * Math.sin(x + y));
    }

    private static float[] addBulge(float[] xyz) {
        int n = xyz.length;
        float[] t = new float[n];
        for (int i = 0; i < n; i += 3) {
            float x = xyz[i];
            float y = xyz[i + 1];
            float z = xyz[i + 2];
            t[i] = x;
            t[i + 1] = y;
            t[i + 2] = z -= PointGroupTest.exp(x, y);
        }
        return t;
    }

    private static float exp(float x, float y) {
        x -= 5.0f;
        y -= 5.0f;
        return (float)(2.0 * Math.exp(-(x *= 0.4f) * x - (y *= 0.8f) * y));
    }

    private static float[] makeColors(float[] xyz) {
        int nv = xyz.length / 3;
        float[] rgb = new float[3 * nv];
        int jv = 0;
        int jc = 0;
        for (int iv = 0; iv < nv; ++iv) {
            float x = xyz[jv++];
            float y = xyz[jv++];
            float z = xyz[jv++];
            float s = 1.0f / (float)Math.sqrt(x * x + y * y + z * z);
            rgb[jc++] = x * s;
            rgb[jc++] = y * s;
            rgb[jc++] = z * s;
        }
        return rgb;
    }
}

