/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.Group;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.sgl.Selectable;
import edu.mines.jtk.sgl.View;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class World
extends Group {
    private ArrayList<View> _viewList = new ArrayList();
    private HashSet<Node> _selectedSet = new HashSet();

    public int countViews() {
        return this._viewList.size();
    }

    public Iterator<View> getViews() {
        return this._viewList.iterator();
    }

    public int countSelected() {
        return this._selectedSet.size();
    }

    public Iterator<Node> getSelected() {
        return this._selectedSet.iterator();
    }

    public void clearSelected() {
        for (Node node : new ArrayList<Node>(this._selectedSet)) {
            if (!node.isSelected()) continue;
            node.setSelected(false);
        }
    }

    public void clearSelectedExcept(Selectable nodeToIgnore) {
        for (Node node : new ArrayList<Node>(this._selectedSet)) {
            if (node == nodeToIgnore || !node.isSelected()) continue;
            node.setSelected(false);
        }
    }

    @Override
    public void dirtyDraw() {
        this.repaint();
    }

    @Override
    public void dirtyBoundingSphere() {
        super.dirtyBoundingSphere();
    }

    public void repaint() {
        for (View view : this._viewList) {
            view.repaint();
        }
    }

    @Override
    public World getWorld() {
        return this;
    }

    void updateSelectedSet(Node node) {
        if (node instanceof Selectable) {
            if (node.isSelected() && this == node.getWorld()) {
                this._selectedSet.add(node);
            } else {
                this._selectedSet.remove(node);
            }
        }
        if (node instanceof Group) {
            Group group = (Group)node;
            Iterator<Node> children = group.getChildren();
            while (children.hasNext()) {
                Node child = children.next();
                this.updateSelectedSet(child);
            }
        }
    }

    boolean addView(View view) {
        if (!this._viewList.contains(view)) {
            this._viewList.add(view);
            return true;
        }
        return false;
    }

    boolean removeView(View view) {
        return this._viewList.remove(view);
    }
}

