/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class DocumentSizeFilter
extends DocumentFilter {
    private final int maxCharacters;

    public DocumentSizeFilter(int maxChars) {
        this.maxCharacters = maxChars;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.lengthOK(fb, str, 0)) {
            super.insertString(fb, offs, str, a);
        } else {
            this.reject();
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
        if (this.lengthOK(fb, str, length)) {
            super.replace(fb, offs, length, str, a);
        } else {
            this.reject();
        }
    }

    private boolean lengthOK(DocumentFilter.FilterBypass fb, String str, int length) {
        int charCount = fb.getDocument().getLength() + str.length() - length;
        return charCount <= this.maxCharacters;
    }

    private void reject() {
        Toolkit.getDefaultToolkit().beep();
    }
}

