/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apposed.appose.Environment;

public interface Builder<T extends Builder<T>> {
    public String name();

    public Environment build() throws IOException;

    default public Environment rebuild() throws IOException {
        this.delete();
        return this.build();
    }

    public void delete() throws IOException;

    public Environment wrap(File var1) throws IOException;

    public T env(String var1, String var2);

    public T env(Map<String, String> var1);

    public T name(String var1);

    default public T base(String envDir) {
        return this.base(new File(envDir));
    }

    public T base(File var1);

    default public T channels(String ... channels) {
        return this.channels(Arrays.asList(channels));
    }

    public T channels(List<String> var1);

    default public T file(String path) throws IOException {
        Path filePath = Paths.get(path, new String[0]);
        String fileContent = new String(Files.readAllBytes(filePath), StandardCharsets.UTF_8);
        return this.content(fileContent);
    }

    public T content(String var1);

    default public T url(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((length = stream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String urlContent = result.toString(StandardCharsets.UTF_8.name());
            T t = this.content(urlContent);
            return t;
        }
    }

    public T scheme(String var1);

    public T subscribeProgress(ProgressConsumer var1);

    public T subscribeOutput(Consumer<String> var1);

    public T subscribeError(Consumer<String> var1);

    default public T flags(String ... flags) {
        return this.flags(Arrays.asList(flags));
    }

    public T flags(List<String> var1);

    default public T logDebug() {
        return this.subscribeOutput(System.out::print).subscribeError(System.err::print);
    }

    public static interface ProgressConsumer {
        public void accept(String var1, long var2, long var4);
    }
}

