/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apposed.appose.Builder;
import org.apposed.appose.Environment;
import org.apposed.appose.builder.BaseBuilder;
import org.apposed.appose.builder.Mamba;
import org.apposed.appose.scheme.Schemes;
import org.apposed.appose.util.FilePaths;

public final class MambaBuilder
extends BaseBuilder<MambaBuilder> {
    public MambaBuilder() {
    }

    public MambaBuilder(String source) throws IOException {
        this.file(source);
    }

    public MambaBuilder(String source, String scheme) throws IOException {
        this.file(source);
        this.scheme = scheme;
    }

    @Override
    public String name() {
        return "mamba";
    }

    @Override
    public Environment build() throws IOException {
        File envDir = this.envDir();
        if (new File(envDir, ".pixi").isDirectory()) {
            throw new IOException("Cannot use MambaBuilder: environment already managed by Pixi at " + envDir);
        }
        if (new File(envDir, "pyvenv.cfg").exists()) {
            throw new IOException("Cannot use MambaBuilder: environment already managed by UV/venv at " + envDir);
        }
        boolean isCondaDir = new File(envDir, "conda-meta").isDirectory();
        if (isCondaDir) {
            return this.createEnvironment(envDir);
        }
        if (this.sourceContent == null) {
            throw new IllegalStateException("No source specified for MambaBuilder. Use .file() or .content()");
        }
        if (this.scheme == null) {
            this.scheme = Schemes.fromContent(this.sourceContent).name();
        }
        if (!"environment.yml".equals(this.scheme)) {
            throw new IllegalArgumentException("MambaBuilder only supports environment.yml scheme, got: " + this.scheme);
        }
        Mamba mamba = new Mamba();
        mamba.setOutputConsumer(msg -> this.outputSubscribers.forEach(sub -> sub.accept(msg)));
        mamba.setErrorConsumer(msg -> this.errorSubscribers.forEach(sub -> sub.accept(msg)));
        mamba.setDownloadProgressConsumer((cur, max) -> this.progressSubscribers.forEach(subscriber -> subscriber.accept("Downloading micromamba", (long)cur, (long)max)));
        mamba.setEnvVars(this.envVars);
        mamba.setFlags(this.flags);
        if (!this.channels.isEmpty()) {
            throw new UnsupportedOperationException("MambaBuilder does not yet support programmatic channel configuration. Please specify channels in your environment.yml file.");
        }
        try {
            mamba.install();
            mamba.create(envDir);
            File envYaml = new File(envDir, "environment.yml");
            Files.write(envYaml.toPath(), this.sourceContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            mamba.update(envDir, envYaml);
            return this.createEnvironment(envDir);
        }
        catch (InterruptedException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Environment wrap(File envDir) throws IOException {
        FilePaths.ensureDirectory(envDir);
        File envYaml = new File(envDir, "environment.yml");
        if (envYaml.exists() && envYaml.isFile()) {
            this.sourceContent = new String(Files.readAllBytes(envYaml.toPath()), StandardCharsets.UTF_8);
        }
        this.base(envDir);
        return this.build();
    }

    @Override
    public MambaBuilder channels(String ... channels) {
        return (MambaBuilder)super.channels(channels);
    }

    private Environment createEnvironment(File envDir) {
        Mamba mamba = new Mamba();
        final String base = envDir.getAbsolutePath();
        final List<String> launchArgs = Arrays.asList(mamba.command, "run", "-p", base);
        final List<String> binPaths = Collections.singletonList(envDir.toPath().resolve("bin").toString());
        return new Environment(){

            @Override
            public String base() {
                return base;
            }

            @Override
            public List<String> binPaths() {
                return binPaths;
            }

            @Override
            public List<String> launchArgs() {
                return launchArgs;
            }

            @Override
            public Map<String, String> envVars() {
                return MambaBuilder.this.envVars;
            }

            @Override
            public Builder<?> builder() {
                return MambaBuilder.this;
            }
        };
    }
}

