/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.shm;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import org.apposed.appose.SharedMemory;
import org.apposed.appose.ShmFactory;
import org.apposed.appose.shm.ShmBase;
import org.apposed.appose.shm.Shms;
import org.apposed.appose.util.Platforms;

public class ShmWindows
implements ShmFactory {
    @Override
    public SharedMemory create(String name, boolean create, long rsize) {
        if (!Platforms.isWindows()) {
            return null;
        }
        return new SharedMemoryWindows(name, create, rsize);
    }

    private static void cleanup(Pointer pointer, Pointer writePointer, WinNT.HANDLE handle) {
        if (!ShmWindows.isNull(writePointer)) {
            Kernel32.INSTANCE.UnmapViewOfFile(writePointer);
        }
        if (!ShmWindows.isNull(pointer)) {
            Kernel32.INSTANCE.UnmapViewOfFile(pointer);
        }
        if (handle != null) {
            Kernel32.INSTANCE.CloseHandle(handle);
        }
    }

    private static boolean isNull(Pointer p) {
        return p == null || p == Pointer.NULL;
    }

    private static String lastError() {
        int code = Kernel32.INSTANCE.GetLastError();
        return new Win32Exception(code).getMessage() + " (" + code + ")";
    }

    private static class SharedMemoryWindows
    extends ShmBase<WinNT.HANDLE> {
        private SharedMemoryWindows(String name, boolean create, long rsize) {
            super(SharedMemoryWindows.prepareShm(name, create, rsize));
        }

        @Override
        protected void doClose() {
            ShmWindows.cleanup(this.info.pointer, this.info.writePointer, (WinNT.HANDLE)this.info.handle);
        }

        @Override
        protected void doUnlink() {
        }

        private static ShmBase.ShmInfo<WinNT.HANDLE> prepareShm(String name, boolean create, long rsize) {
            String shmName;
            long prevSize;
            if (name == null) {
                while ((prevSize = SharedMemoryWindows.getSHMSize(shmName = Shms.makeFilename(14, "wnsm_"))) >= 0L) {
                }
            } else {
                shmName = name;
                prevSize = SharedMemoryWindows.getSHMSize(shmName);
            }
            Shms.checkSize(shmName, prevSize, rsize);
            WinNT.HANDLE hMapFile = Kernel32.INSTANCE.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, null, 4, (int)(rsize >>> 32), (int)(rsize & 0xFFFFFFFFL), "Local\\" + shmName);
            if (hMapFile == null) {
                throw new RuntimeException("Error creating shared memory: " + ShmWindows.lastError());
            }
            long shm_size = SharedMemoryWindows.getSHMSize(hMapFile);
            Pointer pointer = Kernel32.INSTANCE.MapViewOfFile(hMapFile, 6, 0, 0, 0);
            if (ShmWindows.isNull(pointer)) {
                Kernel32.INSTANCE.CloseHandle(hMapFile);
                throw new RuntimeException("Error mapping shared memory: " + ShmWindows.lastError());
            }
            Pointer writePointer = Kernel32.INSTANCE.VirtualAllocEx(Kernel32.INSTANCE.GetCurrentProcess(), pointer, new BaseTSD.SIZE_T(rsize), 4096, 4);
            if (ShmWindows.isNull(writePointer)) {
                ShmWindows.cleanup(pointer, writePointer, hMapFile);
                throw new RuntimeException("Error committing to the shared memory pages: " + ShmWindows.lastError());
            }
            ShmBase.ShmInfo<WinNT.HANDLE> info = new ShmBase.ShmInfo<WinNT.HANDLE>();
            info.name = shmName;
            info.rsize = rsize;
            info.size = shm_size;
            info.pointer = pointer;
            info.writePointer = writePointer;
            info.handle = hMapFile;
            info.unlinkOnClose = create;
            return info;
        }

        private static long getSHMSize(String name) {
            WinNT.HANDLE hMapFile = Kernel32.INSTANCE.OpenFileMapping(4, false, "Local\\" + name);
            if (hMapFile == null) {
                return -1L;
            }
            return SharedMemoryWindows.getSHMSize(hMapFile);
        }

        private static long getSHMSize(WinNT.HANDLE hMapFile) {
            if (hMapFile == null) {
                throw new NullPointerException("hMapFile is null.");
            }
            Pointer pSharedMemory = Kernel32.INSTANCE.MapViewOfFile(hMapFile, 4, 0, 0, 0);
            if (pSharedMemory == null) {
                Kernel32.INSTANCE.CloseHandle(hMapFile);
                throw new RuntimeException("MapViewOfFile failed with error: " + ShmWindows.lastError());
            }
            WinNT.MEMORY_BASIC_INFORMATION mbi = new WinNT.MEMORY_BASIC_INFORMATION();
            if (Kernel32.INSTANCE.VirtualQueryEx(Kernel32.INSTANCE.GetCurrentProcess(), pSharedMemory, mbi, new BaseTSD.SIZE_T((long)mbi.size())).intValue() == 0) {
                throw new RuntimeException("Failed to get shared memory segment size: " + ShmWindows.lastError());
            }
            long size = mbi.regionSize.longValue();
            Kernel32.INSTANCE.UnmapViewOfFile(pSharedMemory);
            return size;
        }
    }
}

