/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.util;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Environments {
    private Environments() {
    }

    public static Map<String, String> envVars(String ... keys) {
        HashMap<String, String> envVars = new HashMap<String, String>();
        for (String key : keys) {
            String value = System.getenv(key);
            if (value == null) continue;
            envVars.put(key, value);
        }
        return envVars;
    }

    public static List<String> systemPath() {
        String pathEnv = System.getenv("PATH");
        if (pathEnv == null || pathEnv.isEmpty()) {
            return new ArrayList<String>();
        }
        String separator = File.pathSeparator;
        return Arrays.asList(pathEnv.split(separator));
    }

    public static String apposeEnvsDir() {
        String envsDir = System.getProperty("appose.envs-dir");
        if (envsDir != null) {
            return envsDir;
        }
        String userHome = System.getProperty("user.home");
        return Paths.get(userHome, ".local", "share", "appose").toString();
    }
}

