/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import net.imglib2.img.basictypeaccess.volatiles.VolatileAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileArrayDataAccess;
import net.imglib2.type.label.LabelMultisetEntryList;
import net.imglib2.type.label.LongMappedAccessData;

public class VolatileLabelMultisetArray
implements VolatileAccess,
VolatileArrayDataAccess<VolatileLabelMultisetArray> {
    private boolean isValid = false;
    private final int[] data;
    private final long[] argMax;
    private final LongMappedAccessData listData;
    private final long listDataUsedSizeInBytes;

    public VolatileLabelMultisetArray(int numEntities, boolean isValid, long[] argMax) {
        this.data = new int[numEntities];
        this.argMax = argMax;
        this.listData = LongMappedAccessData.factory.createStorage(16L);
        this.listDataUsedSizeInBytes = 0L;
        this.isValid = isValid;
    }

    public VolatileLabelMultisetArray(int[] data, LongMappedAccessData listData, boolean isValid, long[] argMax) {
        this(data, listData, -1L, isValid, argMax);
    }

    public VolatileLabelMultisetArray(int[] data, LongMappedAccessData listData, long listDataUsedSizeInBytes, boolean isValid, long[] argMax) {
        this.data = data;
        this.argMax = argMax;
        this.listData = listData;
        this.listDataUsedSizeInBytes = listDataUsedSizeInBytes;
        this.isValid = isValid;
    }

    public void getValue(int index, LabelMultisetEntryList ref) {
        ref.referToDataAt(this.listData, this.data[index]);
    }

    public VolatileLabelMultisetArray createArray(int numEntities) {
        return new VolatileLabelMultisetArray(numEntities, true, new long[]{-2L});
    }

    public VolatileLabelMultisetArray createArray(int numEntities, boolean isValid) {
        return new VolatileLabelMultisetArray(numEntities, isValid, new long[]{-2L});
    }

    public int[] getCurrentStorageArray() {
        return this.data;
    }

    public LongMappedAccessData getListData() {
        return this.listData;
    }

    public long getListDataUsedSizeInBytes() {
        return this.listDataUsedSizeInBytes;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getRequiredNumberOfBytes() {
        return VolatileLabelMultisetArray.getRequiredNumberOfBytes(this);
    }

    public static int getRequiredNumberOfBytes(VolatileLabelMultisetArray array) {
        return VolatileLabelMultisetArray.getRequiredNumberOfBytes(array.argMax.length, array.data, (int)array.getListDataUsedSizeInBytes());
    }

    public static int getRequiredNumberOfBytes(int numArgMax, int[] listOffsets, int listSizeInBytes) {
        return 4 + 8 * numArgMax + 4 * listOffsets.length + listSizeInBytes;
    }

    public int getArrayLength() {
        return this.data.length;
    }

    public long argMax(int offset) {
        if (this.data.length == 0) {
            return -2L;
        }
        return this.argMax[offset];
    }

    public void setArgMax(int offset, long val) {
        this.argMax[offset] = val;
    }

    public long[] argMaxCopy() {
        return (long[])this.argMax.clone();
    }

    private int toIndex(int offset) {
        return this.data[offset];
    }
}

