/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.app;

import java.io.File;
import org.scijava.plugin.RichPlugin;
import org.scijava.plugin.SingletonPlugin;
import org.scijava.util.AppUtils;
import org.scijava.util.Manifest;
import org.scijava.util.POM;

public interface App
extends RichPlugin,
SingletonPlugin {
    default public String getTitle() {
        return this.getInfo().getName();
    }

    public String getGroupId();

    public String getArtifactId();

    public POM getPOM();

    public Manifest getManifest();

    default public String getInfo(boolean mem) {
        String appTitle = this.getTitle();
        String appVersion = this.getVersion();
        String javaVersion = System.getProperty("java.version");
        String osArch = System.getProperty("os.arch");
        long maxMem = Runtime.getRuntime().maxMemory();
        long totalMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totalMem - freeMem;
        long usedMB = usedMem / 0x100000L;
        long maxMB = maxMem / 0x100000L;
        StringBuilder sb = new StringBuilder();
        sb.append(appTitle + " " + appVersion);
        sb.append("; Java " + javaVersion + " [" + osArch + "]");
        if (mem) {
            sb.append("; " + usedMB + "MB of " + maxMB + "MB");
        }
        return sb.toString();
    }

    default public String getSystemProperty() {
        return this.getInfo().getName().toLowerCase() + ".dir";
    }

    default public File getBaseDirectory() {
        return AppUtils.getBaseDirectory(this.getSystemProperty(), this.getClass(), null);
    }

    public void about();

    default public void prefs() {
    }

    default public void quit() {
        this.getContext().dispose();
    }

    @Override
    default public String getVersion() {
        String v;
        String v2;
        Manifest m = this.getManifest();
        if (m != null && (v2 = m.getVersion()) != null) {
            return v2;
        }
        POM p = this.getPOM();
        if (p != null && (v = p.getVersion()) != null) {
            return v;
        }
        return "Unknown";
    }
}

