/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.event;

import java.util.ArrayList;
import java.util.Set;
import org.scijava.event.EventDetails;
import org.scijava.event.EventHandler;
import org.scijava.event.EventHistory;
import org.scijava.event.EventHistoryListener;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultEventHistory
extends AbstractService
implements EventHistory {
    @Parameter
    private EventService eventService;
    private ArrayList<EventDetails> history = new ArrayList();
    private ArrayList<EventHistoryListener> listeners = new ArrayList();
    private boolean active;

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void clear() {
        this.history.clear();
    }

    @Override
    public String toHTML(Set<Class<? extends SciJavaEvent>> filtered, Set<Class<? extends SciJavaEvent>> highlighted) {
        StringBuilder sb = new StringBuilder();
        for (EventDetails details : this.history) {
            Class<? extends SciJavaEvent> eventType = details.getEventType();
            if (filtered != null && filtered.contains(eventType)) continue;
            boolean bold = highlighted != null && highlighted.contains(eventType);
            sb.append(details.toHTML(bold));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(EventHistoryListener l) {
        ArrayList<EventHistoryListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(l);
        }
        this.setActive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(EventHistoryListener l) {
        ArrayList<EventHistoryListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
        if (this.listeners.isEmpty()) {
            this.setActive(false);
        }
    }

    @EventHandler
    protected void onEvent(SciJavaEvent event) {
        if (!this.active) {
            return;
        }
        EventDetails details = new EventDetails(event);
        this.history.add(details);
        this.notifyListeners(details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(EventDetails details) {
        ArrayList<EventHistoryListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (EventHistoryListener l : this.listeners) {
                l.eventOccurred(details);
            }
        }
    }
}

