/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import org.scijava.util.IntCoords;

public class IntRect {
    public int x;
    public int y;
    public int width;
    public int height;

    public IntRect() {
    }

    public IntRect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean intersects(IntRect r) {
        int tw = this.width;
        int th = this.height;
        int rw = r.width;
        int rh = r.height;
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int tx = this.x;
        int ty = this.y;
        int rx = r.x;
        int ry = r.y;
        rh += ry;
        tw += tx;
        th += ty;
        boolean rtn = !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
        return rtn;
    }

    public IntRect intersection(IntRect r) {
        int newX = Math.max(this.x, r.x);
        int newY = Math.max(this.y, r.y);
        int newW = Math.min(this.x + this.width, r.x + r.width) - this.x;
        int newH = Math.min(this.y + this.height, r.y + r.height) - this.y;
        if (newW < 0) {
            newW = 0;
        }
        if (newH < 0) {
            newH = 0;
        }
        return new IntRect(newX, newY, newW, newH);
    }

    public boolean contains(IntCoords coords) {
        return coords.x >= this.x && coords.x < this.x + this.width && coords.y >= this.y && coords.y < this.y + this.height;
    }

    public IntCoords getTopLeft() {
        return new IntCoords(this.x, this.y);
    }

    public IntCoords getBottomRight() {
        return new IntCoords(this.x + this.width, this.y + this.height);
    }

    public String toString() {
        return "x=" + this.x + ", y=" + this.y + ", w=" + this.width + ", h=" + this.height;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntRect)) {
            return false;
        }
        IntRect rect = (IntRect)o;
        return this.x == rect.x && this.y == rect.y && this.width == rect.width && this.height == rect.height;
    }

    public int hashCode() {
        int b1 = this.x & 0xFF;
        int b2 = this.y & 0xFF;
        int b3 = this.width & 0xFF;
        int b4 = this.height & 0xFF;
        return b1 | b2 << 8 | b3 << 16 | b4 << 24;
    }
}

