/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.file;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URI;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractSaveUnsavedChangesAction;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.util.ResourceBundleUtil;

public class LoadFileAction
extends AbstractSaveUnsavedChangesAction {
    public static final String ID = "file.load";

    public LoadFileAction(Application app, @Nullable View view) {
        super(app, view);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    protected URIChooser getChooser(View view) {
        URIChooser chsr = (URIChooser)view.getComponent().getClientProperty("loadChooser");
        if (chsr == null) {
            chsr = this.getApplication().getModel().createSaveChooser(this.getApplication(), view);
            view.getComponent().putClientProperty("loadChooser", chsr);
        }
        return chsr;
    }

    @Override
    public void doIt(final View view) {
        URIChooser fileChooser = this.getChooser(view);
        Window wAncestor = SwingUtilities.getWindowAncestor(view.getComponent());
        final Component oldFocusOwner = wAncestor == null ? null : wAncestor.getFocusOwner();
        JSheet.showOpenSheet(fileChooser, (Component)view.getComponent(), new SheetListener(){

            @Override
            public void optionSelected(SheetEvent evt) {
                if (evt.getOption() == 0) {
                    URI uri = evt.getChooser() instanceof JFileURIChooser && evt.getFileChooser().getFileFilter() instanceof ExtensionFileFilter ? ((ExtensionFileFilter)evt.getFileChooser().getFileFilter()).makeAcceptable(evt.getFileChooser().getSelectedFile()).toURI() : evt.getChooser().getSelectedURI();
                    LoadFileAction.this.loadViewFromURI(view, uri, evt.getChooser());
                } else {
                    view.setEnabled(true);
                    if (oldFocusOwner != null) {
                        oldFocusOwner.requestFocus();
                    }
                }
            }
        });
    }

    public void loadViewFromURI(final View view, final URI uri, final URIChooser chooser) {
        view.setEnabled(false);
        view.execute(new Worker(){

            protected Object construct() throws IOException {
                view.read(uri, chooser);
                return null;
            }

            protected void done(Object value) {
                view.setURI(uri);
                view.setEnabled(true);
                LoadFileAction.this.getApplication().addRecentURI(uri);
            }

            @Override
            protected void failed(Throwable value) {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                JSheet.showMessageSheet(view.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("file.load.couldntLoad.message", URIUtil.getName(uri)) + "</b><p>" + (value == null ? "" : value), 0, new SheetListener(){

                    @Override
                    public void optionSelected(SheetEvent evt) {
                        view.clear();
                        view.setEnabled(true);
                    }
                });
            }
        });
    }
}

