/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.event.FigureAdapter;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.MoveHandle;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class GraphicalCompositeFigure
extends AbstractCompositeFigure {
    protected HashMap<AttributeKey, Object> attributes = new HashMap();
    private HashSet<AttributeKey> forbiddenAttributes;
    @Nullable
    private Figure presentationFigure;
    private PresentationFigureHandler presentationFigureHandler = new PresentationFigureHandler(this);

    public GraphicalCompositeFigure() {
        this(null);
    }

    public GraphicalCompositeFigure(@Nullable Figure newPresentationFigure) {
        this.setPresentationFigure(newPresentationFigure);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.getPresentationFigure() == null) {
            return super.getBounds();
        }
        return this.getPresentationFigure().getBounds();
    }

    @Override
    public boolean contains(Point2D.Double p) {
        boolean contains = super.contains(p);
        if (!contains && this.getPresentationFigure() != null) {
            contains = this.getPresentationFigure().contains(p);
        }
        return contains;
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().addNotify(drawing);
        }
    }

    @Override
    public void removeNotify(Drawing drawing) {
        super.removeNotify(drawing);
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().removeNotify(drawing);
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = super.getDrawingArea();
        if (this.getPresentationFigure() != null) {
            r.add(this.getPresentationFigure().getDrawingArea());
        }
        return r;
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (this.getLayouter() == null) {
            super.setBounds(anchor, lead);
            this.basicSetPresentationFigureBounds(anchor, lead);
        } else {
            Rectangle2D.Double r = this.getLayouter().layout(this, anchor, lead);
            this.basicSetPresentationFigureBounds(new Point2D.Double(r.getX(), r.getY()), new Point2D.Double(Math.max(lead.x, (double)((int)r.getMaxX())), Math.max(lead.y, (double)((int)r.getMaxY()))));
            this.invalidate();
        }
    }

    protected void superBasicSetBounds(Point2D.Double anchor, Point2D.Double lead) {
        super.setBounds(anchor, lead);
    }

    protected void basicSetPresentationFigureBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().setBounds(anchor, lead);
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        super.transform(tx);
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().transform(tx);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawPresentationFigure(g);
        super.draw(g);
    }

    protected void drawPresentationFigure(Graphics2D g) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().draw(g);
        }
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            MoveHandle.addMoveHandles(this, handles);
        }
        return handles;
    }

    public void setPresentationFigure(@Nullable Figure newPresentationFigure) {
        if (this.presentationFigure != null) {
            this.presentationFigure.removeFigureListener(this.presentationFigureHandler);
            if (this.getDrawing() != null) {
                this.presentationFigure.removeNotify(this.getDrawing());
            }
        }
        this.presentationFigure = newPresentationFigure;
        if (this.presentationFigure != null) {
            this.presentationFigure.addFigureListener(this.presentationFigureHandler);
            if (this.getDrawing() != null) {
                this.presentationFigure.addNotify(this.getDrawing());
            }
        }
    }

    public Figure getPresentationFigure() {
        return this.presentationFigure;
    }

    @Override
    public GraphicalCompositeFigure clone() {
        GraphicalCompositeFigure that = (GraphicalCompositeFigure)super.clone();
        Figure figure = that.presentationFigure = this.presentationFigure == null ? null : this.presentationFigure.clone();
        if (that.presentationFigure != null) {
            that.presentationFigure.addFigureListener(that.presentationFigureHandler);
        }
        that.attributes = (HashMap)this.attributes.clone();
        that.forbiddenAttributes = this.forbiddenAttributes == null ? null : (HashSet)this.forbiddenAttributes.clone();
        return that;
    }

    public void remap(HashMap<Figure, Figure> oldToNew, boolean disconnectIfNotInMap) {
        super.remap(oldToNew, disconnectIfNotInMap);
        if (this.presentationFigure != null) {
            this.presentationFigure.remap(oldToNew, disconnectIfNotInMap);
        }
    }

    @Override
    public <T> void set(AttributeKey<T> key, T newValue) {
        if (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(key)) {
            if (this.getPresentationFigure() != null) {
                this.getPresentationFigure().set(key, newValue);
            }
            T oldValue = key.put(this.attributes, newValue);
            this.fireAttributeChanged(key, oldValue, newValue);
        }
    }

    public void setAttributeEnabled(AttributeKey key, boolean b) {
        if (this.forbiddenAttributes == null) {
            this.forbiddenAttributes = new HashSet();
        }
        if (b) {
            this.forbiddenAttributes.remove(key);
        } else {
            this.forbiddenAttributes.add(key);
        }
    }

    @Override
    public <T> T get(AttributeKey<T> key) {
        if (this.getPresentationFigure() != null) {
            return this.getPresentationFigure().get(key);
        }
        return !this.attributes.containsKey(key) ? key.getDefaultValue() : key.get(this.attributes);
    }

    protected void applyAttributesTo(Figure that) {
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            that.set(entry.getKey(), entry.getValue());
        }
    }

    protected void writeAttributes(DOMOutput out) throws IOException {
        Figure prototype = (Figure)out.getPrototype();
        boolean isElementOpen = false;
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            Object attributeValue;
            Object prototypeValue;
            AttributeKey key = entry.getKey();
            if (this.forbiddenAttributes != null && this.forbiddenAttributes.contains(key) || (prototypeValue = prototype.get(key)) == (attributeValue = this.get(key)) && (prototypeValue == null || attributeValue == null || prototypeValue.equals(attributeValue))) continue;
            if (!isElementOpen) {
                out.openElement("a");
                isElementOpen = true;
            }
            out.openElement(key.getKey());
            out.writeObject(entry.getValue());
            out.closeElement();
        }
        if (isElementOpen) {
            out.closeElement();
        }
    }

    protected void readAttributes(DOMInput in) throws IOException {
        if (in.getElementCount("a") > 0) {
            in.openElement("a");
            for (int i = in.getElementCount() - 1; i >= 0; --i) {
                in.openElement(i);
                String name = in.getTagName();
                Object value = in.readObject();
                AttributeKey key = this.getAttributeKey(name);
                if (key != null && key.isAssignable(value) && (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(key))) {
                    this.set(key, value);
                }
                in.closeElement();
            }
            in.closeElement();
        }
    }

    @Override
    public void read(DOMInput in) throws IOException {
        super.read(in);
        this.readAttributes(in);
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        super.write(out);
        this.writeAttributes(out);
    }

    protected AttributeKey getAttributeKey(String name) {
        return AttributeKeys.supportedAttributeMap.get(name);
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>(this.attributes);
    }

    public Point2D.Double chop(Point2D.Double from) {
        Rectangle2D.Double r = this.getBounds();
        if (this.get(AttributeKeys.STROKE_COLOR) != null) {
            double grow;
            switch (this.get(AttributeKeys.STROKE_PLACEMENT)) {
                default: {
                    grow = AttributeKeys.getStrokeTotalWidth(this);
                    break;
                }
                case OUTSIDE: {
                    grow = AttributeKeys.getStrokeTotalWidth(this);
                    break;
                }
                case INSIDE: {
                    grow = 0.0;
                }
            }
            Geom.grow(r, grow, grow);
        }
        return Geom.angleToPoint(r, Geom.pointToAngle(r, from));
    }

    private static class PresentationFigureHandler
    extends FigureAdapter
    implements UndoableEditListener,
    Serializable {
        private GraphicalCompositeFigure owner;

        private PresentationFigureHandler(GraphicalCompositeFigure owner) {
            this.owner = owner;
        }

        @Override
        public void figureRequestRemove(FigureEvent e) {
            this.owner.remove(e.getFigure());
        }

        @Override
        public void figureChanged(FigureEvent e) {
            if (!this.owner.isChanging()) {
                this.owner.willChange();
                this.owner.fireFigureChanged(e);
                this.owner.changed();
            }
        }

        @Override
        public void areaInvalidated(FigureEvent e) {
            if (!this.owner.isChanging()) {
                this.owner.fireAreaInvalidated(e.getInvalidatedArea());
            }
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            this.owner.fireUndoableEditHappened(e.getEdit());
        }
    }
}

