/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.action.AbstractDrawingViewAction;

public class ZoomAction
extends AbstractDrawingViewAction {
    private double scaleFactor;
    @Nullable
    private AbstractButton button;
    private String label;

    public ZoomAction(@Nullable DrawingEditor editor, double scaleFactor, @Nullable AbstractButton button) {
        this((DrawingView)null, scaleFactor, button);
        this.setEditor(editor);
    }

    public ZoomAction(@Nullable DrawingView view, double scaleFactor, @Nullable AbstractButton button) {
        super(view);
        this.scaleFactor = scaleFactor;
        this.button = button;
        this.label = (int)(scaleFactor * 100.0) + " %";
        this.putValue("Default", this.label);
        this.putValue("Name", this.label);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.button != null) {
            this.button.setText(this.label);
        }
        final Rectangle vRect = this.getView().getComponent().getVisibleRect();
        final double oldFactor = this.getView().getScaleFactor();
        this.getView().setScaleFactor(this.scaleFactor);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (vRect != null) {
                    vRect.x = (int)((double)vRect.x / oldFactor * ZoomAction.this.scaleFactor);
                    vRect.y = (int)((double)vRect.y / oldFactor * ZoomAction.this.scaleFactor);
                    vRect.width = (int)((double)vRect.width / oldFactor * ZoomAction.this.scaleFactor);
                    vRect.height = (int)((double)vRect.height / oldFactor * ZoomAction.this.scaleFactor);
                    vRect.x += vRect.width / 3;
                    vRect.y += vRect.height / 3;
                    vRect.width /= 3;
                    vRect.height /= 3;
                    ZoomAction.this.getView().getComponent().scrollRectToVisible(vRect);
                }
            }
        });
    }
}

