/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.mini;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.GraphicalCompositeFigure;
import org.jhotdraw.draw.ImageFigure;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.layouter.VerticalLayouter;
import org.jhotdraw.draw.tool.DelegationSelectionTool;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Insets2D;

public class FileIconsSample {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                fc.setDialogTitle("Choose a directory");
                if (fc.showOpenDialog(null) != 0) {
                    System.exit(0);
                }
                DefaultDrawing drawing = new DefaultDrawing();
                File dir = fc.getSelectedFile();
                File[] files = dir.listFiles();
                FileSystemView fsv = FileSystemView.getFileSystemView();
                int maxColumn = Math.max((int)Math.sqrt(files.length), 1);
                double tx = 0.0;
                double ty = 0.0;
                double rowHeight = 0.0;
                int i = 0;
                for (File f : files) {
                    Icon icon = fsv.getSystemIcon(f);
                    BufferedImage bimg = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                    Graphics2D g = bimg.createGraphics();
                    icon.paintIcon(null, g, 0, 0);
                    g.dispose();
                    ImageFigure imf = new ImageFigure();
                    imf.setBufferedImage(bimg);
                    imf.set(AttributeKeys.STROKE_COLOR, null);
                    imf.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(icon.getIconWidth(), icon.getIconHeight()));
                    TextAreaFigure tef = new TextAreaFigure(f.getName());
                    Dimension2DDouble dim = tef.getPreferredTextSize(100.0);
                    Insets2D.Double insets = tef.getInsets();
                    tef.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(Math.max(100.0, dim.width) + insets.left + insets.right, dim.height + insets.top + insets.bottom));
                    tef.set(AttributeKeys.STROKE_COLOR, null);
                    tef.set(AttributeKeys.FILL_COLOR, null);
                    tef.set(AttributeKeys.TEXT_ALIGNMENT, AttributeKeys.Alignment.CENTER);
                    GraphicalCompositeFigure gcf = new GraphicalCompositeFigure();
                    gcf.setLayouter(new VerticalLayouter());
                    gcf.set(AttributeKeys.COMPOSITE_ALIGNMENT, AttributeKeys.Alignment.CENTER);
                    gcf.add(imf);
                    gcf.add(tef);
                    gcf.layout();
                    if (i++ % maxColumn == 0) {
                        ty += rowHeight + 20.0;
                        tx = 0.0;
                        rowHeight = 0.0;
                    }
                    Rectangle2D.Double b = gcf.getBounds();
                    rowHeight = Math.max(rowHeight, b.height);
                    AffineTransform at = new AffineTransform();
                    at.translate(tx, ty);
                    gcf.transform(at);
                    tx += b.width + 20.0;
                    drawing.add(gcf);
                }
                JFrame f = new JFrame("Contents of directory " + dir.getName());
                f.setDefaultCloseOperation(3);
                f.setSize(400, 300);
                DefaultDrawingView view = new DefaultDrawingView();
                view.setDrawing(drawing);
                f.getContentPane().add(view.getComponent());
                DefaultDrawingEditor editor = new DefaultDrawingEditor();
                editor.setTool(new DelegationSelectionTool());
                editor.add(view);
                editor.setActiveView(view);
                f.setVisible(true);
            }
        });
    }
}

