/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.jhotdraw.util.ResourceBundleUtil;

public class MessagePanel
extends JPanel {
    @Nullable
    private EventListenerList listeners;
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
    private JButton closeButton;
    private JLabel iconLabel;
    private JLabel messageLabel;

    public MessagePanel() {
        this(null, null);
    }

    public MessagePanel(@Nullable Icon icon, @Nullable String message) {
        this.initComponents();
        this.setIcon(icon);
        this.setMessage(message);
    }

    public void setMessage(@Nullable String message) {
        this.messageLabel.setText(message);
    }

    public void setIcon(@Nullable Icon icon) {
        this.iconLabel.setIcon(icon);
    }

    public void addActionListener(ActionListener listener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
            this.listeners.add(ActionListener.class, listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(ActionListener.class, listener);
            if (this.listeners.getListenerCount() == 0) {
                this.listeners = null;
            }
        }
    }

    private void initComponents() {
        this.iconLabel = new JLabel();
        this.messageLabel = new JLabel();
        this.closeButton = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.iconLabel, new GridBagConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.messageLabel, gridBagConstraints);
        this.closeButton.setText(this.labels.getString("messagePanel.close.text"));
        this.closeButton.setActionCommand("close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.closePerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.closeButton, gridBagConstraints);
    }

    private void closePerformed(ActionEvent evt) {
        for (ActionListener l : (ActionListener[])this.listeners.getListeners(ActionListener.class)) {
            l.actionPerformed(evt);
        }
    }
}

