/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import ij.measure.Calibration;
import java.util.Arrays;
import java.util.Vector;

public class Object3D {
    public int[][] obj_voxels;
    public boolean[] isSurfVoxels;
    public Vector<int[]> surf_voxelsCoord;
    public float mean_gray;
    public float median;
    public float SD;
    public int min;
    public int max;
    public float int_dens = 0.0f;
    public float mean_dist2surf;
    public float median_dist2surf;
    public float SD_dist2surf;
    public int size;
    public int surf_size;
    public float surf_cal;
    public float[] centroid;
    public float[] c_mass;
    public int[] bound_cube_TL;
    public int[] bound_cube_BR;
    public int bound_cube_width;
    public int bound_cube_height;
    public int bound_cube_depth;
    public Calibration cal;
    int currIndex;

    public Object3D(int size, Calibration cal) {
        this.size = size;
        this.currIndex = -1;
        this.obj_voxels = new int[size][4];
        this.isSurfVoxels = new boolean[size];
        this.surf_voxelsCoord = new Vector();
        this.cal = cal;
        this.surf_size = 0;
        this.surf_cal = 0.0f;
    }

    public Object3D(int size) {
        this(size, new Calibration());
    }

    public void addVoxel(int x, int y, int z, int val, boolean isSurf, float surf) {
        ++this.currIndex;
        if (this.currIndex > this.size - 1) {
            throw new IllegalArgumentException("The current Object3D is already full: resize it prior to call addVoxel");
        }
        this.obj_voxels[this.currIndex][0] = x;
        this.obj_voxels[this.currIndex][1] = y;
        this.obj_voxels[this.currIndex][2] = z;
        this.obj_voxels[this.currIndex][3] = val;
        this.isSurfVoxels[this.currIndex] = isSurf;
        if (isSurf) {
            int[] coord = new int[]{x, y, z};
            this.surf_voxelsCoord.add(coord);
            ++this.surf_size;
        }
        this.surf_cal += surf;
        if (this.currIndex == this.size - 1) {
            this.calcStats();
        }
    }

    private void calcStats() {
        int i;
        int i2;
        int i3;
        this.centroid = new float[3];
        this.c_mass = new float[3];
        this.bound_cube_TL = new int[3];
        this.bound_cube_BR = new int[3];
        this.min = this.obj_voxels[0][3];
        this.max = this.obj_voxels[0][3];
        this.int_dens = 0.0f;
        this.mean_dist2surf = 0.0f;
        this.median_dist2surf = 0.0f;
        this.SD_dist2surf = 0.0f;
        for (i3 = 0; i3 < 3; ++i3) {
            this.centroid[i3] = 0.0f;
            this.c_mass[i3] = 0.0f;
            this.bound_cube_TL[i3] = this.obj_voxels[0][i3];
            this.bound_cube_BR[i3] = this.obj_voxels[0][i3];
        }
        for (i3 = 0; i3 < this.size; ++i3) {
            int curr_int_val = this.obj_voxels[i3][3];
            this.int_dens += (float)curr_int_val;
            this.min = Math.min(this.min, curr_int_val);
            this.max = Math.max(this.max, curr_int_val);
            for (int j = 0; j < 3; ++j) {
                int curr_val = this.obj_voxels[i3][j];
                int n = j;
                this.centroid[n] = this.centroid[n] + (float)curr_val;
                int n2 = j;
                this.c_mass[n2] = this.c_mass[n2] + (float)(curr_val * curr_int_val);
                this.bound_cube_TL[j] = Math.min(this.bound_cube_TL[j], curr_val);
                this.bound_cube_BR[j] = Math.max(this.bound_cube_BR[j], curr_val);
            }
        }
        this.bound_cube_width = this.bound_cube_BR[0] - this.bound_cube_TL[0] + 1;
        this.bound_cube_height = this.bound_cube_BR[1] - this.bound_cube_TL[1] + 1;
        this.bound_cube_depth = this.bound_cube_BR[2] - this.bound_cube_TL[2] + 1;
        this.mean_gray = this.int_dens / (float)this.size;
        float[] medianTmp = new float[this.obj_voxels.length];
        for (i2 = 0; i2 < this.obj_voxels.length; ++i2) {
            medianTmp[i2] = this.obj_voxels[i2][3];
        }
        this.median = this.median(medianTmp);
        this.SD = 0.0f;
        if (this.size != 1) {
            for (i2 = 0; i2 < this.obj_voxels.length; ++i2) {
                this.SD += ((float)this.obj_voxels[i2][3] - this.mean_gray) * ((float)this.obj_voxels[i2][3] - this.mean_gray);
            }
            this.SD = (float)Math.sqrt(this.SD / (float)(this.size - 1));
        }
        i2 = 0;
        while (i2 < 3) {
            int n = i2;
            this.centroid[n] = this.centroid[n] / (float)this.size;
            int n3 = i2++;
            this.c_mass[n3] = this.c_mass[n3] / this.int_dens;
        }
        float[] dist2surfArray = new float[this.surf_size];
        int index = 0;
        for (i = 0; i < this.size; ++i) {
            if (!this.isSurfVoxels[i]) continue;
            dist2surfArray[index] = (float)Math.sqrt(this.cal.pixelWidth * this.cal.pixelWidth * (double)((float)this.obj_voxels[i][0] - this.centroid[0]) * (double)((float)this.obj_voxels[i][0] - this.centroid[0]) + this.cal.pixelHeight * this.cal.pixelHeight * (double)((float)this.obj_voxels[i][1] - this.centroid[1]) * (double)((float)this.obj_voxels[i][1] - this.centroid[1]) + this.cal.pixelDepth * this.cal.pixelDepth * (double)((float)this.obj_voxels[i][2] - this.centroid[2]) * (double)((float)this.obj_voxels[i][2] - this.centroid[2]));
            this.mean_dist2surf += dist2surfArray[index];
            ++index;
        }
        this.mean_dist2surf /= (float)this.surf_size;
        this.SD_dist2surf = 0.0f;
        if (this.surf_size != 1) {
            for (i = 0; i < this.surf_size; ++i) {
                this.SD_dist2surf = (float)((double)this.SD_dist2surf + Math.pow(dist2surfArray[i] - this.mean_dist2surf, 2.0));
            }
            this.median_dist2surf = this.median(dist2surfArray);
            this.SD_dist2surf = (float)Math.sqrt(this.SD_dist2surf / (float)(this.surf_size - 1));
        }
    }

    public float median(float[] array) {
        float med = 0.0f;
        int index = 0;
        Arrays.sort(array);
        if ((float)array.length / 2.0f - (float)(array.length / 2) == 0.0f) {
            index = array.length / 2 - 1;
            med = (array[index] + array[index + 1]) / 2.0f;
        } else {
            index = (array.length + 1) / 2 - 1;
            med = array[index];
        }
        return med;
    }
}

