/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.icp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mpicbg.icp.PointMatchIdentification;
import mpicbg.icp.SimplePointMatchIdentification;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.pointdescriptor.exception.NoSuitablePointsException;

public class ICP<P extends Point> {
    final List<P> reference;
    final List<P> target;
    List<PointMatch> pointMatches;
    ArrayList<PointMatch> ambigousMatches;
    PointMatchIdentification<P> pointMatchIdentifier;
    double avgError;
    double maxError;
    int numMatches;

    public ICP(List<P> target, List<P> reference, PointMatchIdentification<P> pointMatchIdentifier) {
        this.reference = reference;
        this.target = target;
        this.ambigousMatches = null;
        this.pointMatches = null;
        this.pointMatchIdentifier = pointMatchIdentifier;
        this.avgError = -1.0;
        this.maxError = -1.0;
        this.numMatches = -1;
    }

    public ICP(List<P> target, List<P> reference, double distanceThreshold) {
        this(target, reference, new SimplePointMatchIdentification(distanceThreshold));
    }

    public ICP(List<P> target, List<P> reference) {
        this(target, reference, new SimplePointMatchIdentification());
    }

    public void runICPIteration(Model<?> lastModel, Model<?> newModel) throws NotEnoughDataPointsException, IllDefinedDataPointsException, NoSuitablePointsException {
        for (Point point : this.target) {
            point.apply(lastModel);
        }
        List<PointMatch> matches = this.pointMatchIdentifier.assignPointMatches(this.target, this.reference);
        this.ambigousMatches = ICP.removeAmbigousMatches(matches);
        newModel.fit(matches);
        for (Point point : this.target) {
            point.apply(newModel);
        }
        this.avgError = PointMatch.meanDistance(matches);
        this.maxError = PointMatch.maxDistance(matches);
        this.numMatches = matches.size();
        this.pointMatches = matches;
    }

    public void estimateIntialModel(List<PointMatch> matches, Model<?> model) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.ambigousMatches = ICP.removeAmbigousMatches(matches);
        model.fit(matches);
        for (Point point : this.target) {
            point.apply(model);
        }
        this.avgError = PointMatch.meanDistance(matches);
        this.maxError = PointMatch.maxDistance(matches);
        this.numMatches = matches.size();
        this.pointMatches = matches;
    }

    public void setPointMatchIdentification(PointMatchIdentification<P> pointMatchIdentifier) {
        this.pointMatchIdentifier = pointMatchIdentifier;
    }

    public PointMatchIdentification<P> getPointMatchIdentification() {
        return this.pointMatchIdentifier;
    }

    public List<PointMatch> getPointMatches() {
        return this.pointMatches;
    }

    public double getAverageError() {
        return this.avgError;
    }

    public double getMaximalError() {
        return this.maxError;
    }

    public int getNumPointMatches() {
        return this.numMatches;
    }

    public int getNumAmbigousMatches() {
        if (this.ambigousMatches == null) {
            return -1;
        }
        return this.ambigousMatches.size();
    }

    public ArrayList<PointMatch> getAmbigousMatches() {
        return this.ambigousMatches;
    }

    public List<P> getTargetPoints() {
        return this.target;
    }

    public List<P> getReferencePoints() {
        return this.reference;
    }

    public static ArrayList<PointMatch> removeAmbigousMatches(List<PointMatch> matches) {
        int i;
        ArrayList<Integer> inconsistentCorrespondences = new ArrayList<Integer>();
        ArrayList<PointMatch> ambigousMatches = new ArrayList<PointMatch>();
        for (i = 0; i < matches.size(); ++i) {
            Point pointReference;
            Point pointTarget = matches.get(i).getP1();
            ArrayList<Integer> inconsistent = ICP.getOccurences(pointTarget, pointReference = matches.get(i).getP2(), matches);
            if (inconsistent.size() <= 0) continue;
            for (int index : inconsistent) {
                if (inconsistentCorrespondences.contains(index)) continue;
                inconsistentCorrespondences.add(index);
            }
        }
        if (inconsistentCorrespondences.size() > 0) {
            Collections.sort(inconsistentCorrespondences);
            for (i = inconsistentCorrespondences.size() - 1; i >= 0; --i) {
                PointMatch pm = matches.get((Integer)inconsistentCorrespondences.get(i));
                ambigousMatches.add(pm);
                matches.remove((Integer)inconsistentCorrespondences.get(i));
            }
        }
        return ambigousMatches;
    }

    protected static ArrayList<Integer> getOccurences(Point pointTarget, Point pointReference, List<PointMatch> list) {
        ArrayList<Integer> occurences = new ArrayList<Integer>();
        boolean differentOccurence = false;
        for (PointMatch pm : list) {
            if (pm.getP2() == pointReference && pm.getP1() != pointTarget) {
                differentOccurence = true;
                break;
            }
            if (pm.getP1() != pointTarget || pm.getP2() == pointReference) continue;
            differentOccurence = true;
            break;
        }
        if (differentOccurence) {
            for (int i = 0; i < list.size(); ++i) {
                PointMatch pm;
                pm = list.get(i);
                if (pm.getP2() == pointReference) {
                    occurences.add(i);
                }
                if (pm.getP1() != pointTarget) continue;
                occurences.add(i);
            }
        } else {
            boolean sameOccurence = false;
            for (int i = 0; i < list.size(); ++i) {
                PointMatch pm = list.get(i);
                if (pm.getP2() != pointReference) continue;
                if (sameOccurence) {
                    occurences.add(i);
                    continue;
                }
                sameOccurence = true;
            }
        }
        return occurences;
    }
}

