/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import java.util.ArrayList;
import mpicbg.spim.fusion.BlendingSimple;
import mpicbg.spim.fusion.CombinedPixelWeightenerFactory;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.registration.ViewDataBeads;

public class BlendingSimpleFactory
implements CombinedPixelWeightenerFactory<BlendingSimple> {
    final double boundary;
    final double percentScaling;
    final double[] boundaryArray;

    public BlendingSimpleFactory(double boundary, double percentScaling) {
        this.boundary = boundary;
        this.boundaryArray = null;
        this.percentScaling = percentScaling;
    }

    public BlendingSimpleFactory(double[] boundary, double percentScaling) {
        this.boundaryArray = boundary;
        this.boundary = 0.0;
        this.percentScaling = percentScaling;
    }

    @Override
    public BlendingSimple createInstance(ArrayList<ViewDataBeads> views) {
        BlendingSimple blending = new BlendingSimple(views);
        if (this.boundaryArray == null) {
            blending.setBorder(this.boundary);
        } else {
            blending.setBorder(this.boundaryArray);
        }
        blending.setPercentScaling(this.percentScaling);
        return blending;
    }

    public void printProperties() {
        IOFunctions.println("BlendingSimpleFactory(): no special properties.");
    }

    @Override
    public String getDescriptiveName() {
        return "Blending";
    }

    public String getErrorMessage() {
        return "";
    }

    public void setParameters(String configuration) {
    }
}

