/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.segmentation;

import fiji.tool.SliceListener;
import fiji.tool.SliceObserver;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import mpicbg.imglib.algorithm.gauss.GaussianConvolutionReal;
import mpicbg.imglib.algorithm.math.LocalizablePoint;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianReal1;
import mpicbg.imglib.algorithm.scalespace.SubpixelLocalization;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.registration.detection.DetectionSegmentation;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.imageplus.FloatImagePlus;
import net.imglib2.view.Views;
import spim.process.fusion.FusionHelper;

public class InteractiveDoG
implements PlugIn {
    final int extraSize = 40;
    final int scrollbarSize = 1000;
    float sigma = 0.5f;
    float sigma2 = 0.5f;
    float threshold = 1.0E-4f;
    public static int standardSensitivity = 4;
    int sensitivity = standardSensitivity;
    float imageSigma = 0.5f;
    float sigmaMin = 0.5f;
    float sigmaMax = 10.0f;
    int sigmaInit = 300;
    float thresholdMin = 1.0E-4f;
    float thresholdMax = 1.0f;
    int thresholdInit = 500;
    double minIntensityImage = Double.NaN;
    double maxIntensityImage = Double.NaN;
    SliceObserver sliceObserver;
    RoiListener roiListener;
    ImagePlus imp;
    int channel = 0;
    Rectangle rectangle;
    Image<FloatType> img;
    FloatImagePlus<net.imglib2.type.numeric.real.FloatType> source;
    ArrayList<DifferenceOfGaussianPeak<FloatType>> peaks;
    Color originalColor = new Color(0.8f, 0.8f, 0.8f);
    Color inactiveColor = new Color(0.95f, 0.95f, 0.95f);
    public Rectangle standardRectangle;
    boolean isComputing = false;
    boolean isStarted = false;
    boolean enableSigma2 = false;
    boolean sigma2IsAdjustable = true;
    boolean lookForMinima = false;
    boolean lookForMaxima = true;
    boolean isFinished = false;
    boolean wasCanceled = false;

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean wasCanceled() {
        return this.wasCanceled;
    }

    public double getInitialSigma() {
        return this.sigma;
    }

    public void setInitialSigma(float value) {
        this.sigma = value;
        this.sigmaInit = InteractiveDoG.computeScrollbarPositionFromValue(this.sigma, this.sigmaMin, this.sigmaMax, 1000);
    }

    public double getSigma2() {
        return this.sigma2;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float value) {
        this.threshold = value;
        double log1001 = Math.log10(1001.0);
        this.thresholdInit = (int)Math.round(1001.0 - Math.pow(10.0, -((double)((this.threshold - this.thresholdMin) / (this.thresholdMax - this.thresholdMin)) * log1001) + log1001));
    }

    public boolean getSigma2WasAdjusted() {
        return this.enableSigma2;
    }

    public boolean getLookForMaxima() {
        return this.lookForMaxima;
    }

    public boolean getLookForMinima() {
        return this.lookForMinima;
    }

    public void setLookForMaxima(boolean lookForMaxima) {
        this.lookForMaxima = lookForMaxima;
    }

    public void setLookForMinima(boolean lookForMinima) {
        this.lookForMinima = lookForMinima;
    }

    public void setSigmaMax(float sigmaMax) {
        this.sigmaMax = sigmaMax;
    }

    public void setSigma2isAdjustable(boolean state) {
        this.sigma2IsAdjustable = state;
    }

    public FloatImagePlus<net.imglib2.type.numeric.real.FloatType> getConvertedImage() {
        return this.source;
    }

    public InteractiveDoG(ImagePlus imp, int channel) {
        this.imp = imp;
        this.channel = channel;
    }

    public InteractiveDoG(ImagePlus imp) {
        this.imp = imp;
    }

    public InteractiveDoG() {
    }

    public void setMinIntensityImage(double min) {
        this.minIntensityImage = min;
    }

    public void setMaxIntensityImage(double max) {
        this.maxIntensityImage = max;
    }

    public void run(String arg) {
        if (this.imp == null) {
            this.imp = WindowManager.getCurrentImage();
        }
        this.standardRectangle = new Rectangle(this.imp.getWidth() / 4, this.imp.getHeight() / 4, this.imp.getWidth() / 2, this.imp.getHeight() / 2);
        if (this.imp.getType() == 4 || this.imp.getType() == 3) {
            IJ.log((String)"Color images are not supported, please convert to 8, 16 or 32-bit grayscale");
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            this.imp.setRoi(this.standardRectangle);
            roi = this.imp.getRoi();
        }
        if (roi.getType() != 0) {
            IJ.log((String)"Only rectangular rois are supported...");
            return;
        }
        this.source = InteractiveDoG.convertToFloat(this.imp, this.channel, 0, this.minIntensityImage, this.maxIntensityImage);
        this.displaySliders();
        this.sliceObserver = new SliceObserver(this.imp, (SliceListener)new ImagePlusListener());
        this.updatePreview(ValueChange.ALL);
        this.isStarted = true;
        this.roiListener = new RoiListener();
        this.imp.getCanvas().addMouseListener((MouseListener)this.roiListener);
    }

    protected void updatePreview(ValueChange change) {
        Overlay o;
        boolean roiChanged = false;
        Roi roi = this.imp.getRoi();
        if (roi == null || roi.getType() != 0) {
            this.imp.setRoi(new Rectangle(this.standardRectangle));
            roi = this.imp.getRoi();
            roiChanged = true;
        }
        Rectangle rect = roi.getBounds();
        if (roiChanged || this.img == null || change == ValueChange.SLICE || rect.getMinX() != this.rectangle.getMinX() || rect.getMaxX() != this.rectangle.getMaxX() || rect.getMinY() != this.rectangle.getMinY() || rect.getMaxY() != this.rectangle.getMaxY()) {
            this.rectangle = rect;
            this.img = this.extractImage(this.source, this.rectangle, 40);
            roiChanged = true;
        }
        if (!roiChanged && change == ValueChange.ROI) {
            this.isComputing = false;
            return;
        }
        if (this.peaks == null || roiChanged || change == ValueChange.SIGMA || change == ValueChange.SLICE || change == ValueChange.ALL) {
            float[] sigmaDiff;
            float K_MIN1_INV;
            float k;
            float[] sigma;
            if (this.enableSigma2) {
                sigma = new float[]{this.sigma, this.sigma2};
                k = sigma[1] / sigma[0];
                K_MIN1_INV = DetectionSegmentation.computeKWeight(k);
                sigmaDiff = DetectionSegmentation.computeSigmaDiff(sigma, this.imageSigma);
            } else {
                k = (float)DetectionSegmentation.computeK(this.sensitivity);
                K_MIN1_INV = DetectionSegmentation.computeKWeight(k);
                sigma = DetectionSegmentation.computeSigma(k, this.sigma);
                sigmaDiff = DetectionSegmentation.computeSigmaDiff(sigma, this.imageSigma);
            }
            this.sigma2 = sigma[1];
            DifferenceOfGaussianReal1 dog = new DifferenceOfGaussianReal1(this.img, (OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory(), (double)sigmaDiff[0], (double)sigmaDiff[1], (double)(this.thresholdMin / 4.0f), (double)K_MIN1_INV);
            dog.setKeepDoGImage(true);
            dog.process();
            SubpixelLocalization subpixel = new SubpixelLocalization(dog.getDoGImage(), (List)dog.getPeaks());
            subpixel.process();
            this.peaks = dog.getPeaks();
        }
        if ((o = this.imp.getOverlay()) == null) {
            o = new Overlay();
            this.imp.setOverlay(o);
        }
        o.clear();
        for (DifferenceOfGaussianPeak<FloatType> peak : this.peaks) {
            if ((!peak.isMax() || !this.lookForMaxima) && (!peak.isMin() || !this.lookForMinima)) continue;
            float x = peak.getPosition(0);
            float y = peak.getPosition(1);
            if (!(Math.abs(((FloatType)peak.getValue()).get()) > this.threshold) || !(x >= 20.0f) || !(y >= 20.0f) || !(x < (float)(rect.width + 20)) || !(y < (float)(rect.height + 20))) continue;
            OvalRoi or = new OvalRoi(Util.round((float)(x - this.sigma)) + rect.x - 20, Util.round((float)(y - this.sigma)) + rect.y - 20, Util.round((float)(this.sigma + this.sigma2)), Util.round((float)(this.sigma + this.sigma2)));
            if (peak.isMax()) {
                or.setStrokeColor(Color.green);
            } else if (peak.isMin()) {
                or.setStrokeColor(Color.red);
            }
            o.add((Roi)or);
        }
        this.imp.updateAndDraw();
        this.isComputing = false;
    }

    public static float computeSigma2(float sigma1, int sensitivity) {
        float k = (float)DetectionSegmentation.computeK(sensitivity);
        float[] sigma = DetectionSegmentation.computeSigma(k, sigma1);
        return sigma[1];
    }

    protected Image<FloatType> extractImage(FloatImagePlus<net.imglib2.type.numeric.real.FloatType> source, Rectangle rectangle, int extraSize) {
        Image img = new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory()).createImage(new int[]{rectangle.width + extraSize, rectangle.height + extraSize});
        int offsetX = rectangle.x - extraSize / 2;
        int offsetY = rectangle.y - extraSize / 2;
        int[] location = new int[source.numDimensions()];
        if (location.length > 2) {
            location[2] = (this.imp.getCurrentSlice() - 1) / this.imp.getNChannels();
        }
        LocalizableCursor cursor = img.createLocalizableCursor();
        Object positionable = offsetX >= 0 && offsetY >= 0 && (long)(offsetX + img.getDimension(0)) < source.dimension(0) && (long)(offsetY + img.getDimension(1)) < source.dimension(1) ? source.randomAccess() : Views.extendMirrorSingle(source).randomAccess();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.getPosition(location);
            location[0] = location[0] + offsetX;
            location[1] = location[1] + offsetY;
            positionable.setPosition(location);
            ((FloatType)cursor.getType()).set(((net.imglib2.type.numeric.real.FloatType)positionable.get()).get());
        }
        return img;
    }

    public static FloatImagePlus<net.imglib2.type.numeric.real.FloatType> convertToFloat(ImagePlus imp, int channel, int timepoint) {
        return InteractiveDoG.convertToFloat(imp, channel, timepoint, Double.NaN, Double.NaN);
    }

    public static FloatImagePlus<net.imglib2.type.numeric.real.FloatType> convertToFloat(ImagePlus imp, int channel, int timepoint, double min, double max) {
        int z;
        ++channel;
        ++timepoint;
        int h = imp.getHeight();
        int w = imp.getWidth();
        ArrayList<float[]> img = new ArrayList<float[]>();
        if (imp.getProcessor() instanceof FloatProcessor) {
            for (z = 0; z < imp.getNSlices(); ++z) {
                img.add((float[])((float[])imp.getStack().getProcessor(imp.getStackIndex(channel, z + 1, timepoint)).getPixels()).clone());
            }
        } else if (imp.getProcessor() instanceof ByteProcessor) {
            for (z = 0; z < imp.getNSlices(); ++z) {
                byte[] pixels = (byte[])imp.getStack().getProcessor(imp.getStackIndex(channel, z + 1, timepoint)).getPixels();
                float[] pixelsF = new float[pixels.length];
                for (int i = 0; i < pixels.length; ++i) {
                    pixelsF[i] = pixels[i] & 0xFF;
                }
                img.add(pixelsF);
            }
        } else if (imp.getProcessor() instanceof ShortProcessor) {
            for (z = 0; z < imp.getNSlices(); ++z) {
                short[] pixels = (short[])imp.getStack().getProcessor(imp.getStackIndex(channel, z + 1, timepoint)).getPixels();
                float[] pixelsF = new float[pixels.length];
                for (int i = 0; i < pixels.length; ++i) {
                    pixelsF[i] = pixels[i] & 0xFFFF;
                }
                img.add(pixelsF);
            }
        } else {
            for (z = 0; z < imp.getNSlices(); ++z) {
                ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(channel, z + 1, timepoint));
                float[] pixelsF = new float[w * h];
                int i = 0;
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        pixelsF[i++] = ip.getPixelValue(x, y);
                    }
                }
                img.add(pixelsF);
            }
        }
        FloatImagePlus<net.imglib2.type.numeric.real.FloatType> i = InteractiveDoG.createImgLib2(img, w, h);
        if (Double.isNaN(min) || Double.isNaN(max) || Double.isInfinite(min) || Double.isInfinite(max) || min == max) {
            FusionHelper.normalizeImage(i);
        } else {
            FusionHelper.normalizeImage(i, (float)min, (float)max);
        }
        return i;
    }

    public static FloatImagePlus<net.imglib2.type.numeric.real.FloatType> createImgLib2(List<float[]> img, int w, int h) {
        ImagePlus imp;
        if (img.size() > 1) {
            ImageStack stack = new ImageStack(w, h);
            for (int z = 0; z < img.size(); ++z) {
                stack.addSlice((ImageProcessor)new FloatProcessor(w, h, img.get(z)));
            }
            imp = new ImagePlus("ImgLib2 FloatImagePlus (3d)", stack);
        } else {
            imp = new ImagePlus("ImgLib2 FloatImagePlus (2d)", (ImageProcessor)new FloatProcessor(w, h, img.get(0)));
        }
        return ImagePlusAdapter.wrapFloat((ImagePlus)imp);
    }

    protected void displaySliders() {
        Frame frame = new Frame("Adjust Difference-of-Gaussian Values");
        frame.setSize(400, 330);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Scrollbar sigma1 = new Scrollbar(0, this.sigmaInit, 10, 0, 1010);
        this.sigma = InteractiveDoG.computeValueFromScrollbarPosition(this.sigmaInit, this.sigmaMin, this.sigmaMax, 1000);
        Scrollbar threshold = new Scrollbar(0, this.thresholdInit, 10, 0, 1010);
        float log1001 = (float)Math.log10(1001.0);
        this.threshold = this.thresholdMin + (log1001 - (float)Math.log10(1001 - this.thresholdInit)) / log1001 * (this.thresholdMax - this.thresholdMin);
        this.sigma2 = InteractiveDoG.computeSigma2(this.sigma, this.sensitivity);
        int sigma2init = InteractiveDoG.computeScrollbarPositionFromValue(this.sigma2, this.sigmaMin, this.sigmaMax, 1000);
        Scrollbar sigma2 = new Scrollbar(0, sigma2init, 10, 0, 1010);
        Label sigmaText1 = new Label("Sigma 1 = " + this.sigma, 1);
        Label sigmaText2 = new Label("Sigma 2 = " + this.sigma2, 1);
        Label thresholdText = new Label("Threshold = " + this.threshold, 1);
        Button apply = new Button("Apply to Stack (will take some time)");
        Button button = new Button("Done");
        Button cancel = new Button("Cancel");
        Checkbox sigma2Enable = new Checkbox("Enable Manual Adjustment of Sigma 2 ", this.enableSigma2);
        Checkbox min = new Checkbox("Look for Minima (red)", this.lookForMinima);
        Checkbox max = new Checkbox("Look for Maxima (green)", this.lookForMaxima);
        frame.setLayout(layout);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        frame.add((Component)sigma1, c);
        ++c.gridy;
        frame.add((Component)sigmaText1, c);
        ++c.gridy;
        frame.add((Component)sigma2, c);
        ++c.gridy;
        frame.add((Component)sigmaText2, c);
        ++c.gridy;
        c.insets = new Insets(0, 65, 0, 65);
        frame.add((Component)sigma2Enable, c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        frame.add((Component)threshold, c);
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridy;
        frame.add((Component)thresholdText, c);
        ++c.gridy;
        c.insets = new Insets(0, 130, 0, 75);
        frame.add((Component)min, c);
        ++c.gridy;
        c.insets = new Insets(0, 125, 0, 75);
        frame.add((Component)max, c);
        ++c.gridy;
        c.insets = new Insets(0, 75, 0, 75);
        frame.add((Component)apply, c);
        ++c.gridy;
        c.insets = new Insets(10, 150, 0, 150);
        frame.add((Component)button, c);
        ++c.gridy;
        c.insets = new Insets(10, 150, 0, 150);
        frame.add((Component)cancel, c);
        sigma1.addAdjustmentListener(new SigmaListener(sigmaText1, this.sigmaMin, this.sigmaMax, 1000, sigma1, sigma2, sigmaText2));
        sigma2.addAdjustmentListener(new Sigma2Listener(this.sigmaMin, this.sigmaMax, 1000, sigma2, sigmaText2));
        threshold.addAdjustmentListener(new ThresholdListener(thresholdText, this.thresholdMin, this.thresholdMax));
        button.addActionListener(new FinishedButtonListener(frame, false));
        cancel.addActionListener(new FinishedButtonListener(frame, true));
        apply.addActionListener(new ApplyButtonListener());
        min.addItemListener(new MinListener());
        max.addItemListener(new MaxListener());
        sigma2Enable.addItemListener(new EnableListener(sigma2, sigmaText2));
        if (!this.sigma2IsAdjustable) {
            sigma2Enable.setEnabled(false);
        }
        frame.addWindowListener(new FrameListener(frame));
        frame.setVisible(true);
        this.originalColor = sigma2.getBackground();
        sigma2.setBackground(this.inactiveColor);
        sigmaText1.setFont(sigmaText1.getFont().deriveFont(1));
        thresholdText.setFont(thresholdText.getFont().deriveFont(1));
    }

    protected final void close(Frame parent, SliceObserver sliceObserver, ImagePlus imp, RoiListener roiListener) {
        if (parent != null) {
            parent.dispose();
        }
        if (sliceObserver != null) {
            sliceObserver.unregister();
        }
        if (imp != null) {
            if (roiListener != null) {
                imp.getCanvas().removeMouseListener((MouseListener)roiListener);
            }
            imp.getOverlay().clear();
            imp.updateAndDraw();
        }
        this.isFinished = true;
    }

    protected static float computeValueFromScrollbarPosition(int scrollbarPosition, float min, float max, int scrollbarSize) {
        return min + (float)scrollbarPosition / (float)scrollbarSize * (max - min);
    }

    protected static int computeScrollbarPositionFromValue(float sigma, float min, float max, int scrollbarSize) {
        return Util.round((float)((sigma - min) / (max - min) * (float)scrollbarSize));
    }

    public static void main(String[] args) {
        new ImageJ();
        ImagePlus imp = new Opener().openImage("/Users/spreibi/Documents/Microscopy/SPIM/HisYFP-SPIM/spim_TL18_Angle0.tif");
        imp.show();
        imp.setSlice(27);
        imp.setRoi(imp.getWidth() / 4, imp.getHeight() / 4, imp.getWidth() / 2, imp.getHeight() / 2);
        new InteractiveDoG().run(null);
    }

    protected class ImagePlusListener
    implements SliceListener {
        protected ImagePlusListener() {
        }

        public void sliceChanged(ImagePlus arg0) {
            if (InteractiveDoG.this.isStarted) {
                while (InteractiveDoG.this.isComputing) {
                    SimpleMultiThreading.threadWait((long)10L);
                }
                InteractiveDoG.this.updatePreview(ValueChange.SLICE);
            }
        }
    }

    protected class ThresholdListener
    implements AdjustmentListener {
        final Label label;
        final float min;
        final float max;
        final float log1001 = (float)Math.log10(1001.0);

        public ThresholdListener(Label label, float min, float max) {
            this.label = label;
            this.min = min;
            this.max = max;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            InteractiveDoG.this.threshold = this.min + (this.log1001 - (float)Math.log10(1001 - event.getValue())) / this.log1001 * (this.max - this.min);
            this.label.setText("Threshold = " + InteractiveDoG.this.threshold);
            if (!InteractiveDoG.this.isComputing) {
                InteractiveDoG.this.updatePreview(ValueChange.THRESHOLD);
            } else if (!event.getValueIsAdjusting()) {
                while (InteractiveDoG.this.isComputing) {
                    SimpleMultiThreading.threadWait((long)10L);
                }
                InteractiveDoG.this.updatePreview(ValueChange.THRESHOLD);
            }
        }
    }

    protected class SigmaListener
    implements AdjustmentListener {
        final Label label;
        final float min;
        final float max;
        final int scrollbarSize;
        final Scrollbar sigmaScrollbar1;
        final Scrollbar sigmaScrollbar2;
        final Label sigmaText2;

        public SigmaListener(Label label, float min, float max, int scrollbarSize, Scrollbar sigmaScrollbar1, Scrollbar sigmaScrollbar2, Label sigmaText2) {
            this.label = label;
            this.min = min;
            this.max = max;
            this.scrollbarSize = scrollbarSize;
            this.sigmaScrollbar1 = sigmaScrollbar1;
            this.sigmaScrollbar2 = sigmaScrollbar2;
            this.sigmaText2 = sigmaText2;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            InteractiveDoG.this.sigma = InteractiveDoG.computeValueFromScrollbarPosition(event.getValue(), this.min, this.max, this.scrollbarSize);
            if (!InteractiveDoG.this.enableSigma2) {
                InteractiveDoG.this.sigma2 = InteractiveDoG.computeSigma2(InteractiveDoG.this.sigma, InteractiveDoG.this.sensitivity);
                this.sigmaText2.setText("Sigma 2 = " + InteractiveDoG.this.sigma2);
                this.sigmaScrollbar2.setValue(InteractiveDoG.computeScrollbarPositionFromValue(InteractiveDoG.this.sigma2, this.min, this.max, this.scrollbarSize));
            } else if (InteractiveDoG.this.sigma > InteractiveDoG.this.sigma2) {
                InteractiveDoG.this.sigma = InteractiveDoG.this.sigma2 - 0.001f;
                this.sigmaScrollbar1.setValue(InteractiveDoG.computeScrollbarPositionFromValue(InteractiveDoG.this.sigma, this.min, this.max, this.scrollbarSize));
            }
            this.label.setText("Sigma 1 = " + InteractiveDoG.this.sigma);
            while (InteractiveDoG.this.isComputing) {
                SimpleMultiThreading.threadWait((long)10L);
            }
            InteractiveDoG.this.updatePreview(ValueChange.SIGMA);
        }
    }

    protected class Sigma2Listener
    implements AdjustmentListener {
        final float min;
        final float max;
        final int scrollbarSize;
        final Scrollbar sigmaScrollbar2;
        final Label sigma2Label;

        public Sigma2Listener(float min, float max, int scrollbarSize, Scrollbar sigmaScrollbar2, Label sigma2Label) {
            this.min = min;
            this.max = max;
            this.scrollbarSize = scrollbarSize;
            this.sigmaScrollbar2 = sigmaScrollbar2;
            this.sigma2Label = sigma2Label;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            if (InteractiveDoG.this.enableSigma2) {
                InteractiveDoG.this.sigma2 = InteractiveDoG.computeValueFromScrollbarPosition(event.getValue(), this.min, this.max, this.scrollbarSize);
                if (InteractiveDoG.this.sigma2 < InteractiveDoG.this.sigma) {
                    InteractiveDoG.this.sigma2 = InteractiveDoG.this.sigma + 0.001f;
                    this.sigmaScrollbar2.setValue(InteractiveDoG.computeScrollbarPositionFromValue(InteractiveDoG.this.sigma2, this.min, this.max, this.scrollbarSize));
                }
                this.sigma2Label.setText("Sigma 2 = " + InteractiveDoG.this.sigma2);
                if (!event.getValueIsAdjusting()) {
                    while (InteractiveDoG.this.isComputing) {
                        SimpleMultiThreading.threadWait((long)10L);
                    }
                    InteractiveDoG.this.updatePreview(ValueChange.SIGMA);
                }
            } else {
                this.sigmaScrollbar2.setValue(InteractiveDoG.computeScrollbarPositionFromValue(InteractiveDoG.this.sigma2, this.min, this.max, this.scrollbarSize));
            }
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        final Frame parent;

        public FrameListener(Frame parent) {
            this.parent = parent;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            InteractiveDoG.this.close(this.parent, InteractiveDoG.this.sliceObserver, InteractiveDoG.this.imp, InteractiveDoG.this.roiListener);
        }
    }

    protected class FinishedButtonListener
    implements ActionListener {
        final Frame parent;
        final boolean cancel;

        public FinishedButtonListener(Frame parent, boolean cancel) {
            this.parent = parent;
            this.cancel = cancel;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            InteractiveDoG.this.wasCanceled = this.cancel;
            InteractiveDoG.this.close(this.parent, InteractiveDoG.this.sliceObserver, InteractiveDoG.this.imp, InteractiveDoG.this.roiListener);
        }
    }

    protected class ApplyButtonListener
    implements ActionListener {
        protected ApplyButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ImagePlus imp;
            try {
                imp = InteractiveDoG.this.source.getImagePlus();
            }
            catch (ImgLibException e) {
                imp = null;
                e.printStackTrace();
            }
            Image source = ImageJFunctions.wrapFloat((ImagePlus)imp);
            IOFunctions.println("Computing DoG ... ");
            ArrayList peaks = DetectionSegmentation.extractBeadsLaPlaceImgLib(source, new OutOfBoundsStrategyMirrorFactory(), InteractiveDoG.this.imageSigma, InteractiveDoG.this.sigma, InteractiveDoG.this.sigma2, InteractiveDoG.this.threshold, InteractiveDoG.this.threshold / 4.0f, InteractiveDoG.this.lookForMaxima, InteractiveDoG.this.lookForMinima, 1);
            IOFunctions.println("Drawing DoG result ... ");
            Image detections = source.createNewImage();
            LocalizableByDimCursor c = detections.createLocalizableByDimCursor();
            for (DifferenceOfGaussianPeak peak : peaks) {
                LocalizablePoint p = new LocalizablePoint(new float[]{peak.getSubPixelPosition(0), peak.getSubPixelPosition(1), peak.getSubPixelPosition(2)});
                c.setPosition((Localizable)p);
                ((FloatType)c.getType()).set(1.0f);
            }
            IOFunctions.println("Convolving DoG result ... ");
            GaussianConvolutionReal gauss = new GaussianConvolutionReal(detections, (OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory(), 2.0);
            gauss.process();
            detections = gauss.getResult();
            IOFunctions.println("Showing DoG result ... ");
            ImageJFunctions.show((Image)detections);
        }
    }

    protected class RoiListener
    implements MouseListener {
        protected RoiListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Roi roi = InteractiveDoG.this.imp.getRoi();
            if (roi == null || roi.getType() != 0) {
                return;
            }
            while (InteractiveDoG.this.isComputing) {
                SimpleMultiThreading.threadWait((long)10L);
            }
            InteractiveDoG.this.updatePreview(ValueChange.ROI);
        }
    }

    protected class MaxListener
    implements ItemListener {
        protected MaxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            boolean oldState = InteractiveDoG.this.lookForMaxima;
            if (arg0.getStateChange() == 2) {
                InteractiveDoG.this.lookForMaxima = false;
            } else if (arg0.getStateChange() == 1) {
                InteractiveDoG.this.lookForMaxima = true;
            }
            if (InteractiveDoG.this.lookForMaxima != oldState) {
                while (InteractiveDoG.this.isComputing) {
                    SimpleMultiThreading.threadWait((long)10L);
                }
                InteractiveDoG.this.updatePreview(ValueChange.MINMAX);
            }
        }
    }

    protected class MinListener
    implements ItemListener {
        protected MinListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            boolean oldState = InteractiveDoG.this.lookForMinima;
            if (arg0.getStateChange() == 2) {
                InteractiveDoG.this.lookForMinima = false;
            } else if (arg0.getStateChange() == 1) {
                InteractiveDoG.this.lookForMinima = true;
            }
            if (InteractiveDoG.this.lookForMinima != oldState) {
                while (InteractiveDoG.this.isComputing) {
                    SimpleMultiThreading.threadWait((long)10L);
                }
                InteractiveDoG.this.updatePreview(ValueChange.MINMAX);
            }
        }
    }

    protected class EnableListener
    implements ItemListener {
        final Scrollbar sigma2;
        final Label sigmaText2;

        public EnableListener(Scrollbar sigma2, Label sigmaText2) {
            this.sigmaText2 = sigmaText2;
            this.sigma2 = sigma2;
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            if (arg0.getStateChange() == 2) {
                this.sigmaText2.setFont(this.sigmaText2.getFont().deriveFont(0));
                this.sigma2.setBackground(InteractiveDoG.this.inactiveColor);
                InteractiveDoG.this.enableSigma2 = false;
            } else if (arg0.getStateChange() == 1) {
                this.sigmaText2.setFont(this.sigmaText2.getFont().deriveFont(1));
                this.sigma2.setBackground(InteractiveDoG.this.originalColor);
                InteractiveDoG.this.enableSigma2 = true;
            }
        }
    }

    public static enum ValueChange {
        SIGMA,
        THRESHOLD,
        SLICE,
        ROI,
        MINMAX,
        ALL;

    }
}

