/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.deconvolution;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.fft2.FFTConvolution;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import spim.Threads;
import spim.process.cuda.Block;
import spim.process.cuda.BlockGeneratorFixedSizePrecise;
import spim.process.cuda.CUDAFourierConvolution;
import spim.process.fusion.deconvolution.AdjustInput;
import spim.process.fusion.deconvolution.MVDeconFFTThreads;
import spim.process.fusion.deconvolution.Mirror;

public class MVDeconFFT {
    public static CUDAFourierConvolution cuda = null;
    private RandomAccessibleInterval<FloatType> image;
    private RandomAccessibleInterval<FloatType> weight;
    private ArrayImg<FloatType, ?> kernel1;
    private ArrayImg<FloatType, ?> kernel2;
    private FFTConvolution<FloatType> fftConvolution1;
    private FFTConvolution<FloatType> fftConvolution2;
    protected int numViews = 0;
    protected final ExecutorService service;
    PSFTYPE iterationType;
    ArrayList<MVDeconFFT> views;
    final int n;
    final boolean useBlocks;
    final boolean useCUDA;
    final boolean useCPU;
    final int[] blockSize;
    final int[] deviceList;
    final int device0;
    final int numDevices;
    final Block[] blocks;
    final boolean saveMemory;
    private ImgFactory<FloatType> blockFactory;
    private ImgFactory<ComplexFloatType> fftFactory;
    int i = -1;

    public MVDeconFFT(RandomAccessibleInterval<FloatType> image, RandomAccessibleInterval<FloatType> weight, ArrayImg<FloatType, ?> kernel, ImgFactory<FloatType> blockFactory, int[] deviceList, boolean useBlocks, int[] blockSize, boolean saveMemory) {
        this.image = image;
        this.kernel1 = kernel;
        this.weight = weight;
        this.n = image.numDimensions();
        this.service = FFTConvolution.createExecutorService((int)Threads.numThreads());
        this.blockFactory = blockFactory;
        try {
            this.fftFactory = blockFactory.imgFactory((Object)new ComplexFloatType());
        }
        catch (IncompatibleTypeException e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot cast ImgFactory for ComplexFloatType.");
        }
        this.deviceList = deviceList;
        this.device0 = deviceList[0];
        this.numDevices = deviceList.length;
        this.saveMemory = saveMemory;
        boolean anyGPU = false;
        boolean anyCPU = false;
        for (int i : deviceList) {
            if (i >= 0) {
                anyGPU = true;
                continue;
            }
            if (i != -1) continue;
            anyCPU = true;
        }
        this.useCUDA = anyGPU;
        this.useCPU = anyCPU;
        if (useBlocks) {
            this.useBlocks = true;
            this.blockSize = new int[this.n];
            for (int d = 0; d < this.blockSize.length; ++d) {
                this.blockSize[d] = blockSize[d];
            }
            long[] imgSize = new long[this.n];
            long[] kernelSize = new long[this.n];
            image.dimensions(imgSize);
            kernel.dimensions(kernelSize);
            BlockGeneratorFixedSizePrecise blockGenerator = new BlockGeneratorFixedSizePrecise(Util.int2long((int[])this.blockSize));
            this.blocks = blockGenerator.divideIntoBlocks(imgSize, kernelSize);
            IOFunctions.println("Number of blocks: " + this.blocks.length);
        } else if (this.useCUDA) {
            this.useBlocks = true;
            this.blockSize = new int[this.n];
            for (int d = 0; d < this.blockSize.length; ++d) {
                this.blockSize[d] = (int)image.dimension(d) + (int)kernel.dimension(d) - 1;
            }
            long[] imgSize = new long[this.n];
            long[] kernelSize = new long[this.n];
            image.dimensions(imgSize);
            kernel.dimensions(kernelSize);
            BlockGeneratorFixedSizePrecise blockGenerator = new BlockGeneratorFixedSizePrecise(Util.int2long((int[])this.blockSize));
            this.blocks = blockGenerator.divideIntoBlocks(imgSize, kernelSize);
            IOFunctions.println("Number of blocks: " + this.blocks.length + " (1 single block for CUDA processing).");
        } else {
            this.blocks = null;
            this.blockSize = null;
            this.useBlocks = false;
        }
    }

    protected void setNumViews(int numViews) {
        this.numViews = numViews;
    }

    protected void init(PSFTYPE iterationType, ArrayList<MVDeconFFT> views) throws IncompatibleTypeException {
        AdjustInput.normImg(this.kernel1);
        this.iterationType = iterationType;
        this.views = views;
        if (this.numViews == 0) {
            System.out.println("Warning, numViews was not set.");
            this.numViews = 1;
        }
        if (this.numViews == 1 || iterationType == PSFTYPE.INDEPENDENT) {
            this.kernel2 = MVDeconFFT.computeInvertedKernel(this.kernel1);
        } else if (iterationType == PSFTYPE.EFFICIENT_BAYESIAN) {
            ArrayImg<FloatType, ?> tmp = MVDeconFFT.computeInvertedKernel(this.kernel1.copy());
            for (MVDeconFFT view : views) {
                if (view == this) continue;
                Img input = MVDeconFFT.computeInvertedKernel(this.kernel1);
                ArrayImg<FloatType, ?> kernel = view.kernel1;
                Img output = input.factory().create(input, input.firstElement());
                FFTConvolution conv1 = new FFTConvolution((RandomAccessible)Views.extendZero(input), input, (RandomAccessible)Views.extendZero(kernel), kernel, (RandomAccessibleInterval)output, (ImgFactory)new ArrayImgFactory());
                conv1.setExecutorService(this.service);
                conv1.setKeepImgFFT(false);
                conv1.convolve();
                input = output;
                kernel = MVDeconFFT.computeInvertedKernel(view.kernel1);
                output = input.factory().create((Dimensions)input, input.firstElement());
                FFTConvolution conv2 = new FFTConvolution((RandomAccessible)Views.extendZero((RandomAccessibleInterval)input), (Interval)input, (RandomAccessible)Views.extendZero(kernel), kernel, (RandomAccessibleInterval)output, (ImgFactory)new ArrayImgFactory());
                conv2.setExecutorService(this.service);
                conv2.setKeepImgFFT(false);
                conv2.convolve();
                ArrayCursor cursor = tmp.cursor();
                for (FloatType t : output) {
                    cursor.fwd();
                    ((FloatType)cursor.get()).set(t.get() * ((FloatType)cursor.get()).get());
                }
            }
            AdjustInput.normImg(tmp);
            this.kernel2 = tmp;
        } else if (iterationType == PSFTYPE.OPTIMIZATION_I) {
            ArrayImg tmp = this.kernel1.copy();
            for (MVDeconFFT view : views) {
                if (view == this) continue;
                ArrayImg<FloatType, ?> input = this.kernel1;
                ArrayImg<FloatType, ?> kernel = MVDeconFFT.computeInvertedKernel(view.kernel1);
                Img output = input.factory().create(input, input.firstElement());
                FFTConvolution conv = new FFTConvolution((RandomAccessible)Views.extendZero(input), input, (RandomAccessible)Views.extendZero(kernel), kernel, (RandomAccessibleInterval)output, (ImgFactory)new ArrayImgFactory());
                conv.setExecutorService(this.service);
                conv.setKeepImgFFT(false);
                conv.convolve();
                ArrayCursor cursor = tmp.cursor();
                for (FloatType t : output) {
                    cursor.fwd();
                    ((FloatType)cursor.get()).set(t.get() * ((FloatType)cursor.get()).get());
                }
            }
            AdjustInput.normImg((IterableInterval<FloatType>)tmp);
            this.kernel2 = MVDeconFFT.computeInvertedKernel(tmp);
        } else {
            ArrayImg<FloatType, ?> exponentialKernel = MVDeconFFT.computeExponentialKernel(this.kernel1, this.numViews);
            AdjustInput.normImg(exponentialKernel);
            this.kernel2 = MVDeconFFT.computeInvertedKernel(exponentialKernel);
        }
    }

    public static ArrayImg<FloatType, ?> computeExponentialKernel(ArrayImg<FloatType, ?> kernel, int numViews) {
        ArrayImg exponentialKernel = kernel.copy();
        for (FloatType f : exponentialKernel) {
            f.set(MVDeconFFT.pow(f.get(), numViews));
        }
        return exponentialKernel;
    }

    public static ArrayImg<FloatType, ?> computeInvertedKernel(ArrayImg<FloatType, ?> kernel) {
        ArrayImg invKernel = kernel.copy();
        for (int d = 0; d < invKernel.numDimensions(); ++d) {
            Mirror.mirror(invKernel, d, Threads.numThreads());
        }
        return invKernel;
    }

    private static final float pow(float value, int power) {
        float result = value;
        for (int i = 1; i < power; ++i) {
            result *= value;
        }
        return result;
    }

    public void setImage(Img<FloatType> image) {
        this.image = image;
        this.setCurrentIteration(-1);
    }

    public void setWeight(Img<FloatType> weight) {
        this.weight = weight;
    }

    public void setKernel(ArrayImg<FloatType, ?> kernel) throws IncompatibleTypeException {
        this.kernel1 = kernel;
        this.init(this.iterationType, this.views);
        this.setCurrentIteration(-1);
    }

    public RandomAccessibleInterval<FloatType> getImage() {
        return this.image;
    }

    public RandomAccessibleInterval<FloatType> getWeight() {
        return this.weight;
    }

    public ArrayImg<FloatType, ?> getKernel1() {
        return this.kernel1;
    }

    public ArrayImg<FloatType, ?> getKernel2() {
        return this.kernel2;
    }

    public void setCurrentIteration(int i) {
        this.i = i;
    }

    public int getCurrentIteration() {
        return this.i;
    }

    public void convolve1(Img<FloatType> image, Img<FloatType> result) {
        int ithread;
        if (this.useCPU) {
            if (this.useBlocks) {
                Img block = this.blockFactory.create(this.blockSize, (Object)new FloatType());
                if (this.fftConvolution1 == null) {
                    this.fftConvolution1 = new FFTConvolution(block, this.kernel1);
                    this.fftConvolution1.setComputeComplexConjugate(false);
                    this.fftConvolution1.setExecutorService(this.service);
                    this.fftConvolution1.setKeepImgFFT(false);
                }
                for (int i = 0; i < this.blocks.length; ++i) {
                    MVDeconFFTThreads.convolve1BlockCPU(this.blocks[i], image, result, (Img<FloatType>)block, this.fftConvolution1, i);
                }
                if (this.saveMemory) {
                    this.fftConvolution1 = null;
                    System.gc();
                }
                return;
            }
            if (this.fftConvolution1 == null) {
                this.fftConvolution1 = new FFTConvolution(this.image, this.kernel1, this.fftFactory);
                this.fftConvolution1.setComputeComplexConjugate(false);
                this.fftConvolution1.setExecutorService(this.service);
                this.fftConvolution1.setKeepImgFFT(false);
            }
            long time = System.currentTimeMillis();
            FFTConvolution<FloatType> fftConv = this.fftConvolution1;
            fftConv.setImg(image);
            fftConv.setOutput(result);
            fftConv.convolve();
            System.out.println(" image: compute " + (System.currentTimeMillis() - time));
            if (this.saveMemory) {
                this.fftConvolution1 = null;
                System.gc();
            }
            return;
        }
        if (this.useCUDA && this.numDevices == 1) {
            Img block = this.blockFactory.create(this.blockSize, (Object)new FloatType());
            for (int i = 0; i < this.blocks.length; ++i) {
                MVDeconFFTThreads.convolve1BlockCUDA(this.blocks[i], this.device0, image, result, (Img<FloatType>)block, this.kernel1, i);
            }
            return;
        }
        AtomicInteger ai = new AtomicInteger();
        Thread[] threads = new Thread[this.deviceList.length];
        for (int i = 0; i < this.deviceList.length; ++i) {
            threads[i] = MVDeconFFTThreads.getCUDAThread1(ai, this.blockFactory, this.blocks, this.blockSize, image, result, this.deviceList[i], this.kernel1);
        }
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread].start();
        }
        try {
            for (ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread].join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public void convolve2(Img<FloatType> image, Img<FloatType> result) {
        int ithread;
        if (this.useCPU) {
            if (this.useBlocks) {
                Img block = this.blockFactory.create(this.blockSize, (Object)new FloatType());
                if (this.fftConvolution2 == null) {
                    this.fftConvolution2 = new FFTConvolution(block, this.kernel2);
                    this.fftConvolution2.setComputeComplexConjugate(false);
                    this.fftConvolution2.setExecutorService(this.service);
                    this.fftConvolution2.setKeepImgFFT(false);
                }
                for (int i = 0; i < this.blocks.length; ++i) {
                    MVDeconFFTThreads.convolve2BlockCPU(this.blocks[i], image, result, (Img<FloatType>)block, this.fftConvolution2);
                }
                if (this.saveMemory) {
                    this.fftConvolution2 = null;
                    System.gc();
                }
                return;
            }
            if (this.fftConvolution2 == null) {
                this.fftConvolution2 = new FFTConvolution(this.image, this.kernel2, this.fftFactory);
                this.fftConvolution2.setComputeComplexConjugate(false);
                this.fftConvolution2.setExecutorService(this.service);
                this.fftConvolution2.setKeepImgFFT(false);
            }
            FFTConvolution<FloatType> fftConv = this.fftConvolution2;
            fftConv.setImg((RandomAccessible)Views.extendValue(image, (Type)new FloatType(1.0f)), image);
            fftConv.setOutput(result);
            fftConv.convolve();
            if (this.saveMemory) {
                this.fftConvolution2 = null;
                System.gc();
            }
            return;
        }
        if (this.useCUDA && this.numDevices == 1) {
            Img block = this.blockFactory.create(this.blockSize, (Object)new FloatType());
            for (int i = 0; i < this.blocks.length; ++i) {
                MVDeconFFTThreads.convolve2BlockCUDA(this.blocks[i], this.device0, image, result, (Img<FloatType>)block, this.kernel2);
            }
            return;
        }
        AtomicInteger ai = new AtomicInteger();
        Thread[] threads = new Thread[this.deviceList.length];
        for (int i = 0; i < this.deviceList.length; ++i) {
            threads[i] = MVDeconFFTThreads.getCUDAThread2(ai, this.blockFactory, this.blocks, this.blockSize, image, result, this.deviceList[i], this.kernel2);
        }
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread].start();
        }
        try {
            for (ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread].join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public static enum PSFTYPE {
        OPTIMIZATION_II,
        OPTIMIZATION_I,
        EFFICIENT_BAYESIAN,
        INDEPENDENT;

    }
}

