/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.deconvolution;

import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.fft2.FFTConvolution;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import spim.process.cuda.Block;
import spim.process.fusion.deconvolution.MVDeconFFT;
import spim.process.interestpointdetection.DifferenceOfGaussianCUDA;

public class MVDeconFFTThreads {
    protected static final void convolve1BlockCPU(Block blockStruct, Img<FloatType> image, Img<FloatType> result, Img<FloatType> block, FFTConvolution<FloatType> fftConvolution1, int i) {
        long time = System.currentTimeMillis();
        blockStruct.copyBlock((RandomAccessible<FloatType>)Views.extendMirrorSingle(image), (RandomAccessibleInterval<FloatType>)block);
        System.out.println(" block " + i + "(CPU): copy " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        fftConvolution1.setImg(block);
        fftConvolution1.setOutput(block);
        fftConvolution1.convolve();
        System.out.println(" block " + i + "(CPU): compute " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        blockStruct.pasteBlock((RandomAccessibleInterval<FloatType>)result, (RandomAccessibleInterval<FloatType>)block);
        System.out.println(" block " + i + "(CPU): paste " + (System.currentTimeMillis() - time));
    }

    protected static final void convolve2BlockCPU(Block blockStruct, Img<FloatType> image, Img<FloatType> result, Img<FloatType> block, FFTConvolution<FloatType> fftConvolution2) {
        blockStruct.copyBlock((RandomAccessible<FloatType>)Views.extendValue(image, (Type)new FloatType(1.0f)), (RandomAccessibleInterval<FloatType>)block);
        fftConvolution2.setImg(block);
        fftConvolution2.setOutput(block);
        fftConvolution2.convolve();
        blockStruct.pasteBlock((RandomAccessibleInterval<FloatType>)result, (RandomAccessibleInterval<FloatType>)block);
    }

    protected static final void convolve1BlockCUDA(Block blockStruct, int deviceId, Img<FloatType> image, Img<FloatType> result, Img<FloatType> block, Img<FloatType> kernel1, int i) {
        long time = System.currentTimeMillis();
        blockStruct.copyBlock((RandomAccessible<FloatType>)Views.extendMirrorSingle(image), (RandomAccessibleInterval<FloatType>)block);
        System.out.println(" block " + i + "(CPU  " + deviceId + "): copy " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        float[] blockF = ((FloatArray)((ArrayImg)block).update(null)).getCurrentStorageArray();
        float[] kernel1F = ((FloatArray)((ArrayImg)kernel1).update(null)).getCurrentStorageArray();
        MVDeconFFT.cuda.convolution3DfftCUDAInPlace(blockF, MVDeconFFTThreads.getCUDACoordinates(DifferenceOfGaussianCUDA.CUDAOutput.getImgSizeInt(block)), kernel1F, MVDeconFFTThreads.getCUDACoordinates(DifferenceOfGaussianCUDA.CUDAOutput.getImgSizeInt(kernel1)), deviceId);
        System.out.println(" block " + i + "(CUDA " + deviceId + "): compute " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        blockStruct.pasteBlock((RandomAccessibleInterval<FloatType>)result, (RandomAccessibleInterval<FloatType>)block);
        System.out.println(" block " + i + "(CPU  " + deviceId + "): paste " + (System.currentTimeMillis() - time));
    }

    protected static final void convolve2BlockCUDA(Block blockStruct, int deviceId, Img<FloatType> image, Img<FloatType> result, Img<FloatType> block, Img<FloatType> kernel2) {
        blockStruct.copyBlock((RandomAccessible<FloatType>)Views.extendValue(image, (Type)new FloatType(1.0f)), (RandomAccessibleInterval<FloatType>)block);
        float[] blockF = ((FloatArray)((ArrayImg)block).update(null)).getCurrentStorageArray();
        float[] kernel2F = ((FloatArray)((ArrayImg)kernel2).update(null)).getCurrentStorageArray();
        MVDeconFFT.cuda.convolution3DfftCUDAInPlace(blockF, MVDeconFFTThreads.getCUDACoordinates(DifferenceOfGaussianCUDA.CUDAOutput.getImgSizeInt(block)), kernel2F, MVDeconFFTThreads.getCUDACoordinates(DifferenceOfGaussianCUDA.CUDAOutput.getImgSizeInt(kernel2)), deviceId);
        blockStruct.pasteBlock((RandomAccessibleInterval<FloatType>)result, (RandomAccessibleInterval<FloatType>)block);
    }

    protected static final Thread getCUDAThread1(final AtomicInteger ai, final ImgFactory<FloatType> blockFactory, final Block[] blocks, final int[] blockSize, final Img<FloatType> image, final Img<FloatType> result, final int deviceId, final Img<FloatType> kernel1) {
        Thread cudaThread1 = new Thread(new Runnable(){

            @Override
            public void run() {
                int i;
                Img block = blockFactory.create(Util.int2long((int[])blockSize), (Object)new FloatType());
                while ((i = ai.getAndIncrement()) < blocks.length) {
                    MVDeconFFTThreads.convolve1BlockCUDA(blocks[i], deviceId, (Img<FloatType>)image, (Img<FloatType>)result, (Img<FloatType>)block, (Img<FloatType>)kernel1, i);
                }
            }
        });
        return cudaThread1;
    }

    protected static final Thread getCUDAThread2(final AtomicInteger ai, final ImgFactory<FloatType> blockFactory, final Block[] blocks, final int[] blockSize, final Img<FloatType> image, final Img<FloatType> result, final int deviceId, final Img<FloatType> kernel2) {
        Thread cudaThread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                int i;
                Img block = blockFactory.create(Util.int2long((int[])blockSize), (Object)new FloatType());
                while ((i = ai.getAndIncrement()) < blocks.length) {
                    MVDeconFFTThreads.convolve2BlockCUDA(blocks[i], deviceId, (Img<FloatType>)image, (Img<FloatType>)result, (Img<FloatType>)block, (Img<FloatType>)kernel2);
                }
            }
        });
        return cudaThread2;
    }

    private static final int[] getCUDACoordinates(int[] c) {
        int[] cuda = new int[c.length];
        for (int d = 0; d < c.length; ++d) {
            cuda[c.length - d - 1] = c[d];
        }
        return cuda;
    }
}

