/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.parallel;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import java.util.function.Function;
import net.imglib2.parallel.ForkJoinExecutorService;
import net.imglib2.parallel.SequentialExecutorService;
import net.imglib2.parallel.TaskExecutor;

public class DefaultTaskExecutor
implements TaskExecutor {
    private final ExecutorService executorService;

    public DefaultTaskExecutor(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public int getParallelism() {
        if (this.executorService instanceof ForkJoinPool) {
            return ((ForkJoinPool)this.executorService).getParallelism();
        }
        if (this.executorService instanceof ThreadPoolExecutor) {
            return Math.max(1, ((ThreadPoolExecutor)this.executorService).getCorePoolSize());
        }
        if (this.executorService instanceof ForkJoinExecutorService) {
            return ((ForkJoinExecutorService)this.executorService).getParallelism();
        }
        if (this.executorService instanceof SequentialExecutorService) {
            return ((SequentialExecutorService)this.executorService).getParallelism();
        }
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void runAll(List<Runnable> tasks) {
        ArrayList<Callable<Object>> callables = new ArrayList<Callable<Object>>(tasks.size());
        for (Runnable task : tasks) {
            callables.add(Executors.callable(task));
        }
        this.invokeAllIgnoreResults(callables);
    }

    @Override
    public int suggestNumberOfTasks() {
        int parallelism = this.getParallelism();
        return parallelism == 1 ? 1 : (int)Math.min((long)parallelism * 4L, Integer.MAX_VALUE);
    }

    @Override
    public <T> void forEach(List<? extends T> parameters, Consumer<? super T> task) {
        ArrayList<Callable<Object>> callables = new ArrayList<Callable<Object>>(parameters.size());
        for (Object parameter : parameters) {
            callables.add(() -> {
                task.accept((Object)parameter);
                return null;
            });
        }
        this.invokeAllIgnoreResults(callables);
    }

    @Override
    public <T, R> List<R> forEachApply(List<? extends T> parameters, Function<? super T, ? extends R> task) {
        ArrayList<Callable<Object>> callables = new ArrayList<Callable<Object>>(parameters.size());
        for (Object parameter : parameters) {
            callables.add(() -> task.apply((Object)parameter));
        }
        try {
            List futures = this.executorService.invokeAll(callables);
            ArrayList results = new ArrayList(futures.size());
            for (Future future : futures) {
                results.add(future.get());
            }
            return results;
        }
        catch (InterruptedException | ExecutionException e) {
            throw this.unwrapExecutionException(e);
        }
    }

    private void invokeAllIgnoreResults(List<Callable<Object>> callables) {
        try {
            List<Future<Object>> futures = this.executorService.invokeAll(callables);
            for (Future<Object> future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw this.unwrapExecutionException(e);
        }
    }

    private RuntimeException unwrapExecutionException(Throwable e) {
        if (e instanceof ExecutionException) {
            Throwable cause = e.getCause();
            cause.setStackTrace(this.concatenate(cause.getStackTrace(), e.getStackTrace()));
            e = cause;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    private <T> T[] concatenate(T[] a, T[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }
}

