/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.parallel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ForkJoinExecutorService
extends AbstractExecutorService {
    public int getParallelism() {
        return this.getPool().getParallelism();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("ForkJoinExecutorService, shutdownNow is not implemented.");
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException("ForkJoinExecutorService, awaitTermination is not implemented.");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        ArrayList<ForkJoinTask<T>> futures = new ArrayList<ForkJoinTask<T>>(collection.size());
        for (Callable<T> callable : collection) {
            futures.add(ForkJoinTask.adapt(callable));
        }
        ForkJoinTask.invokeAll(futures);
        return Collections.unmodifiableList(futures);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException("ForkJoinExecutorService, invokeAll with timeout is not implemented.");
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return ForkJoinTask.adapt(runnable).fork();
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return ForkJoinTask.adapt(runnable, t).fork();
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return ForkJoinTask.adapt(callable).fork();
    }

    @Override
    public void execute(Runnable runnable) {
        ForkJoinTask.adapt(runnable).fork();
    }

    private ForkJoinPool getPool() {
        ForkJoinPool pool = ForkJoinTask.getPool();
        return pool != null ? pool : ForkJoinPool.commonPool();
    }
}

