/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.real;

import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.AbstractComplexType;
import net.imglib2.type.numeric.real.DoubleType;

public abstract class AbstractRealType<T extends AbstractRealType<T>>
extends AbstractComplexType<T>
implements RealType<T> {
    @Override
    public float getImaginaryFloat() {
        return 0.0f;
    }

    @Override
    public double getImaginaryDouble() {
        return 0.0;
    }

    @Override
    public void setImaginary(float complex) {
    }

    @Override
    public void setImaginary(double complex) {
    }

    @Override
    public void inc() {
        this.setReal(this.getRealDouble() + 1.0);
    }

    @Override
    public void dec() {
        this.setReal(this.getRealDouble() - 1.0);
    }

    @Override
    public void set(T c) {
        this.setReal(c.getRealDouble());
    }

    @Override
    public void mul(float c) {
        this.setReal(this.getRealDouble() * (double)c);
    }

    @Override
    public void mul(double c) {
        this.setReal(this.getRealDouble() * c);
    }

    @Override
    public void add(T c) {
        this.setReal(this.getRealDouble() + c.getRealDouble());
    }

    @Override
    public void div(T c) {
        this.setReal(this.getRealDouble() / c.getRealDouble());
    }

    @Override
    public void mul(T c) {
        this.setReal(this.getRealDouble() * c.getRealDouble());
    }

    @Override
    public void sub(T c) {
        this.setReal(this.getRealDouble() - c.getRealDouble());
    }

    @Override
    public void pow(T c) {
        this.setReal(Math.pow(this.getRealDouble(), c.getRealDouble()));
    }

    @Override
    public void pow(double power) {
        this.setReal(Math.pow(this.getRealDouble(), power));
    }

    @Override
    public void setZero() {
        this.setReal(0.0f);
    }

    @Override
    public void setOne() {
        this.setReal(1.0f);
    }

    @Override
    public int compareTo(T other) {
        return Double.compare(this.getRealDouble(), other.getRealDouble());
    }

    @Override
    public boolean valueEquals(T other) {
        return DoubleType.equals(this.getRealDouble(), other.getRealDouble());
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        AbstractRealType t = (AbstractRealType)obj;
        return this.valueEquals((T)t);
    }

    @Override
    public int hashCode() {
        return Double.hashCode(this.getRealDouble());
    }

    @Override
    public float getPowerFloat() {
        return this.getRealFloat();
    }

    @Override
    public double getPowerDouble() {
        return this.getRealDouble();
    }

    @Override
    public float getPhaseFloat() {
        return 0.0f;
    }

    @Override
    public double getPhaseDouble() {
        return 0.0;
    }

    @Override
    public String toString() {
        return "" + this.getRealDouble();
    }
}

