/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.transform.integer.Mixed;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.view.IntervalView;
import net.imglib2.view.TransformBuilder;
import net.imglib2.view.TransformedRandomAccessible;

public class MixedTransformView<T>
implements TransformedRandomAccessible<T> {
    protected final int n;
    protected final RandomAccessible<T> source;
    protected final MixedTransform transformToSource;
    protected RandomAccessible<T> fullViewRandomAccessible;

    public MixedTransformView(RandomAccessible<T> source, Mixed transformToSource) {
        assert (source.numDimensions() == transformToSource.numTargetDimensions());
        this.n = transformToSource.numSourceDimensions();
        while (IntervalView.class.isInstance(source)) {
            source = ((IntervalView)source).getSource();
        }
        if (MixedTransformView.class.isInstance(source)) {
            MixedTransformView v = (MixedTransformView)source;
            this.source = v.getSource();
            this.transformToSource = v.getTransformToSource().concatenate(transformToSource);
        } else {
            this.source = source;
            int sourceDim = this.source.numDimensions();
            this.transformToSource = new MixedTransform(this.n, sourceDim);
            this.transformToSource.set(transformToSource);
        }
        this.fullViewRandomAccessible = null;
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    public String toString() {
        String className = this.getClass().getCanonicalName();
        className = className.substring(className.lastIndexOf(".") + 1, className.length());
        return className + "(" + super.toString() + ")";
    }

    @Override
    public RandomAccessible<T> getSource() {
        return this.source;
    }

    @Override
    public MixedTransform getTransformToSource() {
        return this.transformToSource;
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return TransformBuilder.getEfficientRandomAccessible(interval, this).randomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess() {
        if (this.fullViewRandomAccessible == null) {
            this.fullViewRandomAccessible = TransformBuilder.getEfficientRandomAccessible(null, this);
        }
        return this.fullViewRandomAccessible.randomAccess();
    }

    @Override
    public T getType() {
        return this.source.getType();
    }
}

