/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.util;

import java.util.function.Predicate;
import net.imglib2.cache.AbstractCache;
import net.imglib2.cache.util.KeyBimap;

public class AbstractCacheKeyAdapter<K, L, V, C extends AbstractCache<L, V>>
implements AbstractCache<K, V> {
    protected final C cache;
    protected final KeyBimap<K, L> keymap;

    public AbstractCacheKeyAdapter(C cache, KeyBimap<K, L> keymap) {
        this.cache = cache;
        this.keymap = keymap;
    }

    @Override
    public V getIfPresent(K key) {
        return this.cache.getIfPresent(this.keymap.getTarget(key));
    }

    @Override
    public void persist(K key) {
        this.cache.persist(this.keymap.getTarget(key));
    }

    @Override
    public void persistIf(Predicate<K> condition) {
        this.cache.persistIf(l -> {
            K k = this.keymap.getSource(l);
            return k != null && condition.test(k);
        });
    }

    @Override
    public void persistAll() {
        this.cache.persistIf(l -> this.keymap.getSource(l) != null);
    }

    @Override
    public void invalidate(K key) {
        this.cache.invalidate(this.keymap.getTarget(key));
    }

    @Override
    public void invalidateIf(long parallelismThreshold, Predicate<K> condition) {
        this.cache.invalidateIf(parallelismThreshold, l -> {
            K k = this.keymap.getSource(l);
            return k != null && condition.test(k);
        });
    }

    @Override
    public void invalidateAll(long parallelismThreshold) {
        this.cache.invalidateIf(parallelismThreshold, l -> this.keymap.getSource(l) != null);
    }
}

