/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.notebook.image;

import java.io.IOException;
import net.imagej.notebook.Images;
import net.imagej.notebook.mime.HTMLObject;
import net.imagej.notebook.mime.MIMEConverter;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converters;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import org.scijava.convert.Converter;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class)
public class RAIToHTMLConverter
extends MIMEConverter<RandomAccessibleInterval<?>, HTMLObject> {
    @Override
    protected HTMLObject convert(RandomAccessibleInterval<?> image) {
        return () -> {
            Object element = Util.getTypeFromInterval((Interval)image);
            if (element instanceof ARGBType) {
                return RAIToHTMLConverter.encodeARGBTypeImage((RandomAccessibleInterval<ARGBType>)image);
            }
            if (element instanceof RealType) {
                return RAIToHTMLConverter.encodeRealTypeImage(image);
            }
            throw new IllegalArgumentException("Unsupported image type: " + element.getClass().getName());
        };
    }

    private static String encodeARGBTypeImage(RandomAccessibleInterval<ARGBType> image) throws IOException {
        return RAIToHTMLConverter.encodeRealTypeImage(Converters.argbChannels(image, (int[])new int[]{1, 2, 3}));
    }

    private static <T extends RealType<T>> String encodeRealTypeImage(RandomAccessibleInterval<T> image) throws IOException {
        return Images.html(Images.bufferedImage(image));
    }
}

