/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.api;

import java.util.function.Consumer;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;

public class GpuImage
implements AutoCloseable {
    private ClearCLBuffer clearClBuffer;
    private final Consumer<ClearCLBuffer> onClose;

    public GpuImage(ClearCLBuffer clearClBuffer, Consumer<ClearCLBuffer> onClose) {
        this.clearClBuffer = clearClBuffer;
        this.onClose = onClose;
    }

    public long[] getDimensions() {
        return this.clearClBuffer.getDimensions();
    }

    public long getWidth() {
        return this.clearClBuffer.getWidth();
    }

    public long getHeight() {
        return this.clearClBuffer.getHeight();
    }

    public long getDepth() {
        return this.clearClBuffer.getDepth();
    }

    public ClearCLBuffer clearCLBuffer() {
        return this.clearClBuffer;
    }

    @Override
    public void close() {
        if (this.clearClBuffer == null) {
            return;
        }
        ClearCLBuffer buffer = this.clearClBuffer;
        this.clearClBuffer = null;
        this.onClose.accept(buffer);
    }

    public NativeTypeEnum getNativeType() {
        return this.clearClBuffer.getNativeType();
    }

    public long getNumberOfChannels() {
        return this.clearClBuffer.getNumberOfChannels();
    }
}

